@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Provisioning Artifact for a specified product.
 * > A "provisioning artifact" is also referred to as a "version."
 * > **NOTE:** You cannot create a provisioning artifact for a product that was shared with you.
 * > **NOTE:** The user or role that use this resource must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `template_physical_id` argument.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ProvisioningArtifact("example", {
 *     name: "example",
 *     productId: exampleAwsServicecatalogProduct.id,
 *     type: "CLOUD_FORMATION_TEMPLATE",
 *     templateUrl: `https://${exampleAwsS3Bucket.bucketRegionalDomainName}/${exampleAwsS3Object.key}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ProvisioningArtifact("example",
 *     name="example",
 *     product_id=example_aws_servicecatalog_product["id"],
 *     type="CLOUD_FORMATION_TEMPLATE",
 *     template_url=f"https://{example_aws_s3_bucket['bucketRegionalDomainName']}/{example_aws_s3_object['key']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ProvisioningArtifact("example", new()
 *     {
 *         Name = "example",
 *         ProductId = exampleAwsServicecatalogProduct.Id,
 *         Type = "CLOUD_FORMATION_TEMPLATE",
 *         TemplateUrl = $"https://{exampleAwsS3Bucket.BucketRegionalDomainName}/{exampleAwsS3Object.Key}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewProvisioningArtifact(ctx, "example", &servicecatalog.ProvisioningArtifactArgs{
 * 			Name:        pulumi.String("example"),
 * 			ProductId:   pulumi.Any(exampleAwsServicecatalogProduct.Id),
 * 			Type:        pulumi.String("CLOUD_FORMATION_TEMPLATE"),
 * 			TemplateUrl: pulumi.Sprintf("https://%v/%v", exampleAwsS3Bucket.BucketRegionalDomainName, exampleAwsS3Object.Key),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProvisioningArtifact;
 * import com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisioningArtifact("example", ProvisioningArtifactArgs.builder()
 *             .name("example")
 *             .productId(exampleAwsServicecatalogProduct.id())
 *             .type("CLOUD_FORMATION_TEMPLATE")
 *             .templateUrl(String.format("https://%s/%s", exampleAwsS3Bucket.bucketRegionalDomainName(),exampleAwsS3Object.key()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ProvisioningArtifact
 *     properties:
 *       name: example
 *       productId: ${exampleAwsServicecatalogProduct.id}
 *       type: CLOUD_FORMATION_TEMPLATE
 *       templateUrl: https://${exampleAwsS3Bucket.bucketRegionalDomainName}/${exampleAwsS3Object.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_provisioning_artifact` using the provisioning artifact ID and product ID separated by a colon. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/provisioningArtifact:ProvisioningArtifact example pa-ij2b6lusy6dec:prod-el3an0rma3
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
 * @property active Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
 * @property description Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
 * @property disableTemplateValidation Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
 * @property guidance Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
 * @property name Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
 * @property productId Identifier of the product.
 * @property templatePhysicalId Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
 * @property templateUrl Template source as URL of the CloudFormation template in Amazon S3.
 * The following arguments are optional:
 * @property type Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
 */
public data class ProvisioningArtifactArgs(
    public val acceptLanguage: Output<String>? = null,
    public val active: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val disableTemplateValidation: Output<Boolean>? = null,
    public val guidance: Output<String>? = null,
    public val name: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val templatePhysicalId: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs =
        com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .active(active?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableTemplateValidation(disableTemplateValidation?.applyValue({ args0 -> args0 }))
            .guidance(guidance?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .templatePhysicalId(templatePhysicalId?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisioningArtifactArgs].
 */
@PulumiTagMarker
public class ProvisioningArtifactArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var active: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var disableTemplateValidation: Output<Boolean>? = null

    private var guidance: Output<String>? = null

    private var name: Output<String>? = null

    private var productId: Output<String>? = null

    private var templatePhysicalId: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     */
    @JvmName("hgjofvwgwfptefxl")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
     */
    @JvmName("vubicnvwngoakuat")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     */
    @JvmName("cajeadjrirhxocyn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     */
    @JvmName("umfuqsivqfxqiqcy")
    public suspend fun disableTemplateValidation(`value`: Output<Boolean>) {
        this.disableTemplateValidation = value
    }

    /**
     * @param value Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
     */
    @JvmName("ccjvtewapwwgkawm")
    public suspend fun guidance(`value`: Output<String>) {
        this.guidance = value
    }

    /**
     * @param value Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     */
    @JvmName("ifvidychpasykaeq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier of the product.
     */
    @JvmName("efapvqauweungtjk")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     */
    @JvmName("tlqaxdljkplmtwxi")
    public suspend fun templatePhysicalId(`value`: Output<String>) {
        this.templatePhysicalId = value
    }

    /**
     * @param value Template source as URL of the CloudFormation template in Amazon S3.
     * The following arguments are optional:
     */
    @JvmName("tgjdlvargufrxhlr")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     */
    @JvmName("ohpqtyyjosqfluib")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     */
    @JvmName("trihwpgwcentwivl")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
     */
    @JvmName("ymmibnpedhbbbjse")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     */
    @JvmName("gevkwjvffvcdakog")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     */
    @JvmName("flbnqijpewbqtskp")
    public suspend fun disableTemplateValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTemplateValidation = mapped
    }

    /**
     * @param value Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
     */
    @JvmName("gvnqhxpleffwqovf")
    public suspend fun guidance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guidance = mapped
    }

    /**
     * @param value Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     */
    @JvmName("qptvnegtfcdhbryk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Identifier of the product.
     */
    @JvmName("kcscyhsjpcppmkwq")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     */
    @JvmName("snevpydachetemml")
    public suspend fun templatePhysicalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templatePhysicalId = mapped
    }

    /**
     * @param value Template source as URL of the CloudFormation template in Amazon S3.
     * The following arguments are optional:
     */
    @JvmName("chkwhnpsxcxragip")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     */
    @JvmName("gnwudstbnoexmhhg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProvisioningArtifactArgs = ProvisioningArtifactArgs(
        acceptLanguage = acceptLanguage,
        active = active,
        description = description,
        disableTemplateValidation = disableTemplateValidation,
        guidance = guidance,
        name = name,
        productId = productId,
        templatePhysicalId = templatePhysicalId,
        templateUrl = templateUrl,
        type = type,
    )
}
