@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.kotlin.outputs.ServiceActionDefinition
import com.pulumi.aws.servicecatalog.kotlin.outputs.ServiceActionDefinition.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceAction].
 */
@PulumiTagMarker
public class ServiceActionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceActionArgs = ServiceActionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceActionArgsBuilder.() -> Unit) {
        val builder = ServiceActionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceAction {
        val builtJavaResource = com.pulumi.aws.servicecatalog.ServiceAction(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceAction(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog self-service action.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ServiceAction("example", {
 *     description: "Motor generator unit",
 *     name: "MGU",
 *     definition: {
 *         name: "AWS-RestartEC2Instance",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ServiceAction("example",
 *     description="Motor generator unit",
 *     name="MGU",
 *     definition={
 *         "name": "AWS-RestartEC2Instance",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ServiceAction("example", new()
 *     {
 *         Description = "Motor generator unit",
 *         Name = "MGU",
 *         Definition = new Aws.ServiceCatalog.Inputs.ServiceActionDefinitionArgs
 *         {
 *             Name = "AWS-RestartEC2Instance",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewServiceAction(ctx, "example", &servicecatalog.ServiceActionArgs{
 * 			Description: pulumi.String("Motor generator unit"),
 * 			Name:        pulumi.String("MGU"),
 * 			Definition: &servicecatalog.ServiceActionDefinitionArgs{
 * 				Name: pulumi.String("AWS-RestartEC2Instance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ServiceAction;
 * import com.pulumi.aws.servicecatalog.ServiceActionArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceAction("example", ServiceActionArgs.builder()
 *             .description("Motor generator unit")
 *             .name("MGU")
 *             .definition(ServiceActionDefinitionArgs.builder()
 *                 .name("AWS-RestartEC2Instance")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ServiceAction
 *     properties:
 *       description: Motor generator unit
 *       name: MGU
 *       definition:
 *         name: AWS-RestartEC2Instance
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_service_action` using the service action ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/serviceAction:ServiceAction example act-f1w12eperfslh
 * ```
 */
public class ServiceAction internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.ServiceAction,
) : KotlinCustomResource(javaResource, ServiceActionMapper) {
    /**
     * Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Self-service action definition configuration block. Detailed below.
     */
    public val definition: Output<ServiceActionDefinition>
        get() = javaResource.definition().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Self-service action description.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Self-service action name.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ServiceActionMapper : ResourceMapper<ServiceAction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.ServiceAction::class == javaResource::class

    override fun map(javaResource: Resource): ServiceAction = ServiceAction(
        javaResource as
            com.pulumi.aws.servicecatalog.ServiceAction,
    )
}

/**
 * @see [ServiceAction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceAction].
 */
public suspend fun serviceAction(
    name: String,
    block: suspend ServiceActionResourceBuilder.() -> Unit,
): ServiceAction {
    val builder = ServiceActionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceAction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceAction(name: String): ServiceAction {
    val builder = ServiceActionResourceBuilder()
    builder.name(name)
    return builder.build()
}
