@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ServiceActionArgs.builder
import com.pulumi.aws.servicecatalog.kotlin.inputs.ServiceActionDefinitionArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.ServiceActionDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog self-service action.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.ServiceAction("example", {
 *     description: "Motor generator unit",
 *     name: "MGU",
 *     definition: {
 *         name: "AWS-RestartEC2Instance",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.ServiceAction("example",
 *     description="Motor generator unit",
 *     name="MGU",
 *     definition={
 *         "name": "AWS-RestartEC2Instance",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.ServiceAction("example", new()
 *     {
 *         Description = "Motor generator unit",
 *         Name = "MGU",
 *         Definition = new Aws.ServiceCatalog.Inputs.ServiceActionDefinitionArgs
 *         {
 *             Name = "AWS-RestartEC2Instance",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewServiceAction(ctx, "example", &servicecatalog.ServiceActionArgs{
 * 			Description: pulumi.String("Motor generator unit"),
 * 			Name:        pulumi.String("MGU"),
 * 			Definition: &servicecatalog.ServiceActionDefinitionArgs{
 * 				Name: pulumi.String("AWS-RestartEC2Instance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ServiceAction;
 * import com.pulumi.aws.servicecatalog.ServiceActionArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceAction("example", ServiceActionArgs.builder()
 *             .description("Motor generator unit")
 *             .name("MGU")
 *             .definition(ServiceActionDefinitionArgs.builder()
 *                 .name("AWS-RestartEC2Instance")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:ServiceAction
 *     properties:
 *       description: Motor generator unit
 *       name: MGU
 *       definition:
 *         name: AWS-RestartEC2Instance
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_service_action` using the service action ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/serviceAction:ServiceAction example act-f1w12eperfslh
 * ```
 * @property acceptLanguage Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
 * @property definition Self-service action definition configuration block. Detailed below.
 * @property description Self-service action description.
 * @property name Self-service action name.
 * The following arguments are optional:
 */
public data class ServiceActionArgs(
    public val acceptLanguage: Output<String>? = null,
    public val definition: Output<ServiceActionDefinitionArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ServiceActionArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ServiceActionArgs =
        com.pulumi.aws.servicecatalog.ServiceActionArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceActionArgs].
 */
@PulumiTagMarker
public class ServiceActionArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var definition: Output<ServiceActionDefinitionArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
     */
    @JvmName("blrrucqbuicovtun")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Self-service action definition configuration block. Detailed below.
     */
    @JvmName("frrpvcxbsxgupwtn")
    public suspend fun definition(`value`: Output<ServiceActionDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Self-service action description.
     */
    @JvmName("wgfglqwbapihhmbi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Self-service action name.
     * The following arguments are optional:
     */
    @JvmName("vywkfgdbklsqyfmp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
     */
    @JvmName("grrnguxghftrhfgb")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Self-service action definition configuration block. Detailed below.
     */
    @JvmName("frxsetftgavcndei")
    public suspend fun definition(`value`: ServiceActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Self-service action definition configuration block. Detailed below.
     */
    @JvmName("cbhvqbeuinfdtlfa")
    public suspend fun definition(argument: suspend ServiceActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceActionDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Self-service action description.
     */
    @JvmName("xirgpeowqcqqrwnb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Self-service action name.
     * The following arguments are optional:
     */
    @JvmName("avrnojowiovoibnh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ServiceActionArgs = ServiceActionArgs(
        acceptLanguage = acceptLanguage,
        definition = definition,
        description = description,
        name = name,
    )
}
