@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getAppregistryApplicationPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getConstraintPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getLaunchPathsPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getPortfolioConstraintsPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getPortfolioPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getProductPlain
import com.pulumi.aws.servicecatalog.ServicecatalogFunctions.getProvisioningArtifactsPlain
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetAppregistryApplicationPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetAppregistryApplicationPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetConstraintPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetConstraintPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetLaunchPathsPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetLaunchPathsPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetPortfolioConstraintsPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetPortfolioConstraintsPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetPortfolioPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetPortfolioPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetProductPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetProductPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetProvisioningArtifactsPlainArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.GetProvisioningArtifactsPlainArgsBuilder
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetAppregistryApplicationResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetConstraintResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetLaunchPathsResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetPortfolioConstraintsResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetPortfolioResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetProductResult
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetProvisioningArtifactsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetAppregistryApplicationResult.Companion.toKotlin as getAppregistryApplicationResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetConstraintResult.Companion.toKotlin as getConstraintResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetLaunchPathsResult.Companion.toKotlin as getLaunchPathsResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetPortfolioConstraintsResult.Companion.toKotlin as getPortfolioConstraintsResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetPortfolioResult.Companion.toKotlin as getPortfolioResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetProductResult.Companion.toKotlin as getProductResultToKotlin
import com.pulumi.aws.servicecatalog.kotlin.outputs.GetProvisioningArtifactsResult.Companion.toKotlin as getProvisioningArtifactsResultToKotlin

public object ServicecatalogFunctions {
    /**
     * Data source for managing an AWS Service Catalog AppRegistry Application.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getAppregistryApplication({
     *     id: "application-1234",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_appregistry_application(id="application-1234")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetAppregistryApplication.Invoke(new()
     *     {
     *         Id = "application-1234",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.LookupAppregistryApplication(ctx, &servicecatalog.LookupAppregistryApplicationArgs{
     * 			Id: "application-1234",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetAppregistryApplicationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getAppregistryApplication(GetAppregistryApplicationArgs.builder()
     *             .id("application-1234")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getAppregistryApplication
     *       Arguments:
     *         id: application-1234
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAppregistryApplication.
     * @return A collection of values returned by getAppregistryApplication.
     */
    public suspend fun getAppregistryApplication(argument: GetAppregistryApplicationPlainArgs): GetAppregistryApplicationResult =
        getAppregistryApplicationResultToKotlin(getAppregistryApplicationPlain(argument.toJava()).await())

    /**
     * @see [getAppregistryApplication].
     * @param id Application identifier.
     * @return A collection of values returned by getAppregistryApplication.
     */
    public suspend fun getAppregistryApplication(id: String): GetAppregistryApplicationResult {
        val argument = GetAppregistryApplicationPlainArgs(
            id = id,
        )
        return getAppregistryApplicationResultToKotlin(getAppregistryApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAppregistryApplication].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetAppregistryApplicationPlainArgs].
     * @return A collection of values returned by getAppregistryApplication.
     */
    public suspend fun getAppregistryApplication(argument: suspend GetAppregistryApplicationPlainArgsBuilder.() -> Unit): GetAppregistryApplicationResult {
        val builder = GetAppregistryApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppregistryApplicationResultToKotlin(getAppregistryApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information on a Service Catalog Constraint.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getConstraint({
     *     acceptLanguage: "en",
     *     id: "cons-hrvy0335",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_constraint(accept_language="en",
     *     id="cons-hrvy0335")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetConstraint.Invoke(new()
     *     {
     *         AcceptLanguage = "en",
     *         Id = "cons-hrvy0335",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.LookupConstraint(ctx, &servicecatalog.LookupConstraintArgs{
     * 			AcceptLanguage: pulumi.StringRef("en"),
     * 			Id:             "cons-hrvy0335",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetConstraintArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getConstraint(GetConstraintArgs.builder()
     *             .acceptLanguage("en")
     *             .id("cons-hrvy0335")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getConstraint
     *       Arguments:
     *         acceptLanguage: en
     *         id: cons-hrvy0335
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConstraint.
     * @return A collection of values returned by getConstraint.
     */
    public suspend fun getConstraint(argument: GetConstraintPlainArgs): GetConstraintResult =
        getConstraintResultToKotlin(getConstraintPlain(argument.toJava()).await())

    /**
     * @see [getConstraint].
     * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     * @param description Description of the constraint.
     * @param id Constraint identifier.
     * The following arguments are optional:
     * @return A collection of values returned by getConstraint.
     */
    public suspend fun getConstraint(
        acceptLanguage: String? = null,
        description: String? = null,
        id: String,
    ): GetConstraintResult {
        val argument = GetConstraintPlainArgs(
            acceptLanguage = acceptLanguage,
            description = description,
            id = id,
        )
        return getConstraintResultToKotlin(getConstraintPlain(argument.toJava()).await())
    }

    /**
     * @see [getConstraint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetConstraintPlainArgs].
     * @return A collection of values returned by getConstraint.
     */
    public suspend fun getConstraint(argument: suspend GetConstraintPlainArgsBuilder.() -> Unit): GetConstraintResult {
        val builder = GetConstraintPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConstraintResultToKotlin(getConstraintPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is necessary when provisioning a product. A path also determines the constraints put on the product.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getLaunchPaths({
     *     productId: "prod-yakog5pdriver",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_launch_paths(product_id="prod-yakog5pdriver")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetLaunchPaths.Invoke(new()
     *     {
     *         ProductId = "prod-yakog5pdriver",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.GetLaunchPaths(ctx, &servicecatalog.GetLaunchPathsArgs{
     * 			ProductId: "prod-yakog5pdriver",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetLaunchPathsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getLaunchPaths(GetLaunchPathsArgs.builder()
     *             .productId("prod-yakog5pdriver")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getLaunchPaths
     *       Arguments:
     *         productId: prod-yakog5pdriver
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLaunchPaths.
     * @return A collection of values returned by getLaunchPaths.
     */
    public suspend fun getLaunchPaths(argument: GetLaunchPathsPlainArgs): GetLaunchPathsResult =
        getLaunchPathsResultToKotlin(getLaunchPathsPlain(argument.toJava()).await())

    /**
     * @see [getLaunchPaths].
     * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     * @param productId Product identifier.
     * The following arguments are optional:
     * @return A collection of values returned by getLaunchPaths.
     */
    public suspend fun getLaunchPaths(acceptLanguage: String? = null, productId: String): GetLaunchPathsResult {
        val argument = GetLaunchPathsPlainArgs(
            acceptLanguage = acceptLanguage,
            productId = productId,
        )
        return getLaunchPathsResultToKotlin(getLaunchPathsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchPaths].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetLaunchPathsPlainArgs].
     * @return A collection of values returned by getLaunchPaths.
     */
    public suspend fun getLaunchPaths(argument: suspend GetLaunchPathsPlainArgsBuilder.() -> Unit): GetLaunchPathsResult {
        val builder = GetLaunchPathsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchPathsResultToKotlin(getLaunchPathsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for a Service Catalog Portfolio.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const portfolio = aws.servicecatalog.getPortfolio({
     *     id: "port-07052002",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * portfolio = aws.servicecatalog.get_portfolio(id="port-07052002")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var portfolio = Aws.ServiceCatalog.GetPortfolio.Invoke(new()
     *     {
     *         Id = "port-07052002",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.LookupPortfolio(ctx, &servicecatalog.LookupPortfolioArgs{
     * 			Id: "port-07052002",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetPortfolioArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var portfolio = ServicecatalogFunctions.getPortfolio(GetPortfolioArgs.builder()
     *             .id("port-07052002")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   portfolio:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getPortfolio
     *       Arguments:
     *         id: port-07052002
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPortfolio.
     * @return A collection of values returned by getPortfolio.
     */
    public suspend fun getPortfolio(argument: GetPortfolioPlainArgs): GetPortfolioResult =
        getPortfolioResultToKotlin(getPortfolioPlain(argument.toJava()).await())

    /**
     * @see [getPortfolio].
     * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     * @param id Portfolio identifier.
     * The following arguments are optional:
     * @param tags Tags applied to the portfolio.
     * @return A collection of values returned by getPortfolio.
     */
    public suspend fun getPortfolio(
        acceptLanguage: String? = null,
        id: String,
        tags: Map<String, String>? = null,
    ): GetPortfolioResult {
        val argument = GetPortfolioPlainArgs(
            acceptLanguage = acceptLanguage,
            id = id,
            tags = tags,
        )
        return getPortfolioResultToKotlin(getPortfolioPlain(argument.toJava()).await())
    }

    /**
     * @see [getPortfolio].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetPortfolioPlainArgs].
     * @return A collection of values returned by getPortfolio.
     */
    public suspend fun getPortfolio(argument: suspend GetPortfolioPlainArgsBuilder.() -> Unit): GetPortfolioResult {
        val builder = GetPortfolioPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPortfolioResultToKotlin(getPortfolioPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information on Service Catalog Portfolio Constraints.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getPortfolioConstraints({
     *     portfolioId: "port-3lli3b3an",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_portfolio_constraints(portfolio_id="port-3lli3b3an")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetPortfolioConstraints.Invoke(new()
     *     {
     *         PortfolioId = "port-3lli3b3an",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.GetPortfolioConstraints(ctx, &servicecatalog.GetPortfolioConstraintsArgs{
     * 			PortfolioId: "port-3lli3b3an",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetPortfolioConstraintsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getPortfolioConstraints(GetPortfolioConstraintsArgs.builder()
     *             .portfolioId("port-3lli3b3an")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getPortfolioConstraints
     *       Arguments:
     *         portfolioId: port-3lli3b3an
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPortfolioConstraints.
     * @return A collection of values returned by getPortfolioConstraints.
     */
    public suspend fun getPortfolioConstraints(argument: GetPortfolioConstraintsPlainArgs): GetPortfolioConstraintsResult =
        getPortfolioConstraintsResultToKotlin(getPortfolioConstraintsPlain(argument.toJava()).await())

    /**
     * @see [getPortfolioConstraints].
     * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     * @param portfolioId Portfolio identifier.
     * The following arguments are optional:
     * @param productId Product identifier.
     * @return A collection of values returned by getPortfolioConstraints.
     */
    public suspend fun getPortfolioConstraints(
        acceptLanguage: String? = null,
        portfolioId: String,
        productId: String? = null,
    ): GetPortfolioConstraintsResult {
        val argument = GetPortfolioConstraintsPlainArgs(
            acceptLanguage = acceptLanguage,
            portfolioId = portfolioId,
            productId = productId,
        )
        return getPortfolioConstraintsResultToKotlin(getPortfolioConstraintsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPortfolioConstraints].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetPortfolioConstraintsPlainArgs].
     * @return A collection of values returned by getPortfolioConstraints.
     */
    public suspend fun getPortfolioConstraints(argument: suspend GetPortfolioConstraintsPlainArgsBuilder.() -> Unit): GetPortfolioConstraintsResult {
        val builder = GetPortfolioConstraintsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPortfolioConstraintsResultToKotlin(getPortfolioConstraintsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about a Service Catalog product.
     * > **NOTE:** A "provisioning artifact" is also known as a "version," and a "distributor" is also known as a "vendor."
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getProduct({
     *     id: "prod-dnigbtea24ste",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_product(id="prod-dnigbtea24ste")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetProduct.Invoke(new()
     *     {
     *         Id = "prod-dnigbtea24ste",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.LookupProduct(ctx, &servicecatalog.LookupProductArgs{
     * 			Id: "prod-dnigbtea24ste",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetProductArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getProduct(GetProductArgs.builder()
     *             .id("prod-dnigbtea24ste")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getProduct
     *       Arguments:
     *         id: prod-dnigbtea24ste
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProduct.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: GetProductPlainArgs): GetProductResult =
        getProductResultToKotlin(getProductPlain(argument.toJava()).await())

    /**
     * @see [getProduct].
     * @param acceptLanguage Language code. Valid values are `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     * @param id ID of the product.
     * The following arguments are optional:
     * @param tags Tags applied to the product.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(
        acceptLanguage: String? = null,
        id: String,
        tags: Map<String, String>? = null,
    ): GetProductResult {
        val argument = GetProductPlainArgs(
            acceptLanguage = acceptLanguage,
            id = id,
            tags = tags,
        )
        return getProductResultToKotlin(getProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getProduct].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetProductPlainArgs].
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: suspend GetProductPlainArgsBuilder.() -> Unit): GetProductResult {
        val builder = GetProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductResultToKotlin(getProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the provisioning artifacts for the specified product.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.servicecatalog.getProvisioningArtifacts({
     *     productId: "prod-yakog5pdriver",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.servicecatalog.get_provisioning_artifacts(product_id="prod-yakog5pdriver")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ServiceCatalog.GetProvisioningArtifacts.Invoke(new()
     *     {
     *         ProductId = "prod-yakog5pdriver",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := servicecatalog.GetProvisioningArtifacts(ctx, &servicecatalog.GetProvisioningArtifactsArgs{
     * 			ProductId: "prod-yakog5pdriver",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicecatalog.ServicecatalogFunctions;
     * import com.pulumi.aws.servicecatalog.inputs.GetProvisioningArtifactsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicecatalogFunctions.getProvisioningArtifacts(GetProvisioningArtifactsArgs.builder()
     *             .productId("prod-yakog5pdriver")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:servicecatalog:getProvisioningArtifacts
     *       Arguments:
     *         productId: prod-yakog5pdriver
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProvisioningArtifacts.
     * @return A collection of values returned by getProvisioningArtifacts.
     */
    public suspend fun getProvisioningArtifacts(argument: GetProvisioningArtifactsPlainArgs): GetProvisioningArtifactsResult =
        getProvisioningArtifactsResultToKotlin(getProvisioningArtifactsPlain(argument.toJava()).await())

    /**
     * @see [getProvisioningArtifacts].
     * @param acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     * @param productId Product identifier.
     * The following arguments are optional:
     * @return A collection of values returned by getProvisioningArtifacts.
     */
    public suspend fun getProvisioningArtifacts(acceptLanguage: String? = null, productId: String): GetProvisioningArtifactsResult {
        val argument = GetProvisioningArtifactsPlainArgs(
            acceptLanguage = acceptLanguage,
            productId = productId,
        )
        return getProvisioningArtifactsResultToKotlin(getProvisioningArtifactsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProvisioningArtifacts].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicecatalog&#46;kotlin&#46;inputs&#46;GetProvisioningArtifactsPlainArgs].
     * @return A collection of values returned by getProvisioningArtifacts.
     */
    public suspend fun getProvisioningArtifacts(argument: suspend GetProvisioningArtifactsPlainArgsBuilder.() -> Unit): GetProvisioningArtifactsResult {
        val builder = GetProvisioningArtifactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProvisioningArtifactsResultToKotlin(getProvisioningArtifactsPlain(builtArgument.toJava()).await())
    }
}
