@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagOption].
 */
@PulumiTagMarker
public class TagOptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagOptionArgs = TagOptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagOptionArgsBuilder.() -> Unit) {
        val builder = TagOptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagOption {
        val builtJavaResource = com.pulumi.aws.servicecatalog.TagOption(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TagOption(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Tag Option.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.TagOption("example", {
 *     key: "nyckel",
 *     value: "värde",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.TagOption("example",
 *     key="nyckel",
 *     value="värde")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.TagOption("example", new()
 *     {
 *         Key = "nyckel",
 *         Value = "värde",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewTagOption(ctx, "example", &servicecatalog.TagOptionArgs{
 * 			Key:   pulumi.String("nyckel"),
 * 			Value: pulumi.String("värde"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.TagOption;
 * import com.pulumi.aws.servicecatalog.TagOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TagOption("example", TagOptionArgs.builder()
 *             .key("nyckel")
 *             .value("värde")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:TagOption
 *     properties:
 *       key: nyckel
 *       value: värde
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_tag_option` using the tag option ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/tagOption:TagOption example tag-pjtvagohlyo3m
 * ```
 */
public class TagOption internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.TagOption,
) : KotlinCustomResource(javaResource, TagOptionMapper) {
    /**
     * Whether tag option is active. Default is `true`.
     */
    public val active: Output<Boolean>?
        get() = javaResource.active().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Tag option key.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Tag option value.
     * The following arguments are optional:
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object TagOptionMapper : ResourceMapper<TagOption> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.TagOption::class == javaResource::class

    override fun map(javaResource: Resource): TagOption = TagOption(
        javaResource as
            com.pulumi.aws.servicecatalog.TagOption,
    )
}

/**
 * @see [TagOption].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagOption].
 */
public suspend fun tagOption(name: String, block: suspend TagOptionResourceBuilder.() -> Unit): TagOption {
    val builder = TagOptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagOption].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagOption(name: String): TagOption {
    val builder = TagOptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
