@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagOptionResourceAssociation].
 */
@PulumiTagMarker
public class TagOptionResourceAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagOptionResourceAssociationArgs = TagOptionResourceAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagOptionResourceAssociationArgsBuilder.() -> Unit) {
        val builder = TagOptionResourceAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagOptionResourceAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.TagOptionResourceAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TagOptionResourceAssociation(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Tag Option Resource Association.
 * > **Tip:** A "resource" is either a Service Catalog portfolio or product.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.TagOptionResourceAssociation("example", {
 *     resourceId: "prod-dnigbtea24ste",
 *     tagOptionId: "tag-pjtvyakdlyo3m",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.TagOptionResourceAssociation("example",
 *     resource_id="prod-dnigbtea24ste",
 *     tag_option_id="tag-pjtvyakdlyo3m")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.TagOptionResourceAssociation("example", new()
 *     {
 *         ResourceId = "prod-dnigbtea24ste",
 *         TagOptionId = "tag-pjtvyakdlyo3m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewTagOptionResourceAssociation(ctx, "example", &servicecatalog.TagOptionResourceAssociationArgs{
 * 			ResourceId:  pulumi.String("prod-dnigbtea24ste"),
 * 			TagOptionId: pulumi.String("tag-pjtvyakdlyo3m"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.TagOptionResourceAssociation;
 * import com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TagOptionResourceAssociation("example", TagOptionResourceAssociationArgs.builder()
 *             .resourceId("prod-dnigbtea24ste")
 *             .tagOptionId("tag-pjtvyakdlyo3m")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:TagOptionResourceAssociation
 *     properties:
 *       resourceId: prod-dnigbtea24ste
 *       tagOptionId: tag-pjtvyakdlyo3m
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_tag_option_resource_association` using the tag option ID and resource ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/tagOptionResourceAssociation:TagOptionResourceAssociation example tag-pjtvyakdlyo3m:prod-dnigbtea24ste
 * ```
 */
public class TagOptionResourceAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.TagOptionResourceAssociation,
) : KotlinCustomResource(javaResource, TagOptionResourceAssociationMapper) {
    /**
     * ARN of the resource.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Creation time of the resource.
     */
    public val resourceCreatedTime: Output<String>
        get() = javaResource.resourceCreatedTime().applyValue({ args0 -> args0 })

    /**
     * Description of the resource.
     */
    public val resourceDescription: Output<String>
        get() = javaResource.resourceDescription().applyValue({ args0 -> args0 })

    /**
     * Resource identifier.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Description of the resource.
     */
    public val resourceName: Output<String>
        get() = javaResource.resourceName().applyValue({ args0 -> args0 })

    /**
     * Tag Option identifier.
     */
    public val tagOptionId: Output<String>
        get() = javaResource.tagOptionId().applyValue({ args0 -> args0 })
}

public object TagOptionResourceAssociationMapper : ResourceMapper<TagOptionResourceAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.TagOptionResourceAssociation::class == javaResource::class

    override fun map(javaResource: Resource): TagOptionResourceAssociation =
        TagOptionResourceAssociation(
            javaResource as
                com.pulumi.aws.servicecatalog.TagOptionResourceAssociation,
        )
}

/**
 * @see [TagOptionResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagOptionResourceAssociation].
 */
public suspend fun tagOptionResourceAssociation(
    name: String,
    block: suspend TagOptionResourceAssociationResourceBuilder.() -> Unit,
): TagOptionResourceAssociation {
    val builder = TagOptionResourceAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagOptionResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagOptionResourceAssociation(name: String): TagOptionResourceAssociation {
    val builder = TagOptionResourceAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
