@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Tag Option Resource Association.
 * > **Tip:** A "resource" is either a Service Catalog portfolio or product.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicecatalog.TagOptionResourceAssociation("example", {
 *     resourceId: "prod-dnigbtea24ste",
 *     tagOptionId: "tag-pjtvyakdlyo3m",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicecatalog.TagOptionResourceAssociation("example",
 *     resource_id="prod-dnigbtea24ste",
 *     tag_option_id="tag-pjtvyakdlyo3m")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceCatalog.TagOptionResourceAssociation("example", new()
 *     {
 *         ResourceId = "prod-dnigbtea24ste",
 *         TagOptionId = "tag-pjtvyakdlyo3m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicecatalog"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicecatalog.NewTagOptionResourceAssociation(ctx, "example", &servicecatalog.TagOptionResourceAssociationArgs{
 * 			ResourceId:  pulumi.String("prod-dnigbtea24ste"),
 * 			TagOptionId: pulumi.String("tag-pjtvyakdlyo3m"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.TagOptionResourceAssociation;
 * import com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TagOptionResourceAssociation("example", TagOptionResourceAssociationArgs.builder()
 *             .resourceId("prod-dnigbtea24ste")
 *             .tagOptionId("tag-pjtvyakdlyo3m")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicecatalog:TagOptionResourceAssociation
 *     properties:
 *       resourceId: prod-dnigbtea24ste
 *       tagOptionId: tag-pjtvyakdlyo3m
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_tag_option_resource_association` using the tag option ID and resource ID. For example:
 * ```sh
 * $ pulumi import aws:servicecatalog/tagOptionResourceAssociation:TagOptionResourceAssociation example tag-pjtvyakdlyo3m:prod-dnigbtea24ste
 * ```
 * @property resourceId Resource identifier.
 * @property tagOptionId Tag Option identifier.
 */
public data class TagOptionResourceAssociationArgs(
    public val resourceId: Output<String>? = null,
    public val tagOptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs =
        com.pulumi.aws.servicecatalog.TagOptionResourceAssociationArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .tagOptionId(tagOptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagOptionResourceAssociationArgs].
 */
@PulumiTagMarker
public class TagOptionResourceAssociationArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var tagOptionId: Output<String>? = null

    /**
     * @param value Resource identifier.
     */
    @JvmName("bkihgfhrcqsvjold")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Tag Option identifier.
     */
    @JvmName("wjyppghlsrudhdky")
    public suspend fun tagOptionId(`value`: Output<String>) {
        this.tagOptionId = value
    }

    /**
     * @param value Resource identifier.
     */
    @JvmName("belgocchbpvgtoqu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Tag Option identifier.
     */
    @JvmName("wyromipjuhxvtlok")
    public suspend fun tagOptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagOptionId = mapped
    }

    internal fun build(): TagOptionResourceAssociationArgs = TagOptionResourceAssociationArgs(
        resourceId = resourceId,
        tagOptionId = tagOptionId,
    )
}
