@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.GetAppregistryApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAppregistryApplication.
 * @property id Application identifier.
 */
public data class GetAppregistryApplicationPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.GetAppregistryApplicationPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.GetAppregistryApplicationPlainArgs =
        com.pulumi.aws.servicecatalog.inputs.GetAppregistryApplicationPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppregistryApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetAppregistryApplicationPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Application identifier.
     */
    @JvmName("wobqekgdhvmulyrm")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetAppregistryApplicationPlainArgs = GetAppregistryApplicationPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
