@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.GetPortfolioPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPortfolio.
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property id Portfolio identifier.
 * The following arguments are optional:
 * @property tags Tags applied to the portfolio.
 */
public data class GetPortfolioPlainArgs(
    public val acceptLanguage: String? = null,
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.GetPortfolioPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.GetPortfolioPlainArgs =
        com.pulumi.aws.servicecatalog.inputs.GetPortfolioPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPortfolioPlainArgs].
 */
@PulumiTagMarker
public class GetPortfolioPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("hxwkbqfdmkwwgxdc")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     * The following arguments are optional:
     */
    @JvmName("qrkurbtoqhllgmfj")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Tags applied to the portfolio.
     */
    @JvmName("uxfatdykkhidqrgv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags applied to the portfolio.
     */
    @JvmName("srxsnisjbvkayeem")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPortfolioPlainArgs = GetPortfolioPlainArgs(
        acceptLanguage = acceptLanguage,
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
