@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.GetProvisioningArtifactsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProvisioningArtifacts.
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property productId Product identifier.
 * The following arguments are optional:
 */
public data class GetProvisioningArtifactsPlainArgs(
    public val acceptLanguage: String? = null,
    public val productId: String,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.GetProvisioningArtifactsPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.GetProvisioningArtifactsPlainArgs =
        com.pulumi.aws.servicecatalog.inputs.GetProvisioningArtifactsPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProvisioningArtifactsPlainArgs].
 */
@PulumiTagMarker
public class GetProvisioningArtifactsPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var productId: String? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("yyqiusesqwfmipug")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Product identifier.
     * The following arguments are optional:
     */
    @JvmName("parnobpviqrovqje")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    internal fun build(): GetProvisioningArtifactsPlainArgs = GetProvisioningArtifactsPlainArgs(
        acceptLanguage = acceptLanguage,
        productId = productId ?: throw PulumiNullFieldException("productId"),
    )
}
