@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Parameter key.
 * @property usePreviousValue Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
 * @property value Parameter value.
 */
public data class ProvisionedProductProvisioningParameterArgs(
    public val key: Output<String>,
    public val usePreviousValue: Output<Boolean>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs =
        com.pulumi.aws.servicecatalog.inputs.ProvisionedProductProvisioningParameterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .usePreviousValue(usePreviousValue?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisionedProductProvisioningParameterArgs].
 */
@PulumiTagMarker
public class ProvisionedProductProvisioningParameterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var usePreviousValue: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Parameter key.
     */
    @JvmName("eluuhxynioeuwpjg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
     */
    @JvmName("ufkgcddtrxttprnt")
    public suspend fun usePreviousValue(`value`: Output<Boolean>) {
        this.usePreviousValue = value
    }

    /**
     * @param value Parameter value.
     */
    @JvmName("qibojvpnfhtqnufk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Parameter key.
     */
    @JvmName("jyhepflfreouvogg")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
     */
    @JvmName("scsnuekxhtirdhxe")
    public suspend fun usePreviousValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePreviousValue = mapped
    }

    /**
     * @param value Parameter value.
     */
    @JvmName("fepfmaxjggqrbfsl")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProvisionedProductProvisioningParameterArgs =
        ProvisionedProductProvisioningParameterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            usePreviousValue = usePreviousValue,
            `value` = `value`,
        )
}
