@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.ProvisionedProductStackSetProvisioningPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accounts One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
 * @property failureToleranceCount Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
 * @property failureTolerancePercentage Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
 * @property maxConcurrencyCount Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
 * @property maxConcurrencyPercentage Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
 * @property regions One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
 */
public data class ProvisionedProductStackSetProvisioningPreferencesArgs(
    public val accounts: Output<List<String>>? = null,
    public val failureToleranceCount: Output<Int>? = null,
    public val failureTolerancePercentage: Output<Int>? = null,
    public val maxConcurrencyCount: Output<Int>? = null,
    public val maxConcurrencyPercentage: Output<Int>? = null,
    public val regions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.ProvisionedProductStackSetProvisioningPreferencesArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.ProvisionedProductStackSetProvisioningPreferencesArgs =
        com.pulumi.aws.servicecatalog.inputs.ProvisionedProductStackSetProvisioningPreferencesArgs.builder()
            .accounts(accounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .failureToleranceCount(failureToleranceCount?.applyValue({ args0 -> args0 }))
            .failureTolerancePercentage(failureTolerancePercentage?.applyValue({ args0 -> args0 }))
            .maxConcurrencyCount(maxConcurrencyCount?.applyValue({ args0 -> args0 }))
            .maxConcurrencyPercentage(maxConcurrencyPercentage?.applyValue({ args0 -> args0 }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProvisionedProductStackSetProvisioningPreferencesArgs].
 */
@PulumiTagMarker
public class ProvisionedProductStackSetProvisioningPreferencesArgsBuilder internal constructor() {
    private var accounts: Output<List<String>>? = null

    private var failureToleranceCount: Output<Int>? = null

    private var failureTolerancePercentage: Output<Int>? = null

    private var maxConcurrencyCount: Output<Int>? = null

    private var maxConcurrencyPercentage: Output<Int>? = null

    private var regions: Output<List<String>>? = null

    /**
     * @param value One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
     */
    @JvmName("cidhorimvgowvnls")
    public suspend fun accounts(`value`: Output<List<String>>) {
        this.accounts = value
    }

    @JvmName("ycdcethxbreokpbx")
    public suspend fun accounts(vararg values: Output<String>) {
        this.accounts = Output.all(values.asList())
    }

    /**
     * @param values One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
     */
    @JvmName("hkeqkexnmrdwjdjp")
    public suspend fun accounts(values: List<Output<String>>) {
        this.accounts = Output.all(values)
    }

    /**
     * @param value Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
     */
    @JvmName("tlbwxgrrdjqikred")
    public suspend fun failureToleranceCount(`value`: Output<Int>) {
        this.failureToleranceCount = value
    }

    /**
     * @param value Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
     */
    @JvmName("uhkhqnebswgyecmi")
    public suspend fun failureTolerancePercentage(`value`: Output<Int>) {
        this.failureTolerancePercentage = value
    }

    /**
     * @param value Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
     */
    @JvmName("gjfacwvmntsotbcn")
    public suspend fun maxConcurrencyCount(`value`: Output<Int>) {
        this.maxConcurrencyCount = value
    }

    /**
     * @param value Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
     */
    @JvmName("uyubrkfpkdnefnml")
    public suspend fun maxConcurrencyPercentage(`value`: Output<Int>) {
        this.maxConcurrencyPercentage = value
    }

    /**
     * @param value One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
     */
    @JvmName("qwmhngrfhsmgeyta")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("aqopbwoiwwcsernr")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
     */
    @JvmName("yubcfxmfspqqyhsp")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
     */
    @JvmName("hfudkjkdlnloqdmg")
    public suspend fun accounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param values One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
     */
    @JvmName("nytexeqiljdecfvy")
    public suspend fun accounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param value Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
     */
    @JvmName("encidcngaymumtug")
    public suspend fun failureToleranceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureToleranceCount = mapped
    }

    /**
     * @param value Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
     */
    @JvmName("hercnoljpxfhwyry")
    public suspend fun failureTolerancePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureTolerancePercentage = mapped
    }

    /**
     * @param value Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
     */
    @JvmName("uvqwgtxywrhlueon")
    public suspend fun maxConcurrencyCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrencyCount = mapped
    }

    /**
     * @param value Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
     */
    @JvmName("xklpbejdaxspwmfl")
    public suspend fun maxConcurrencyPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrencyPercentage = mapped
    }

    /**
     * @param value One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
     */
    @JvmName("anqwrscinbbqaxhy")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
     */
    @JvmName("ngntgplpottwurwt")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): ProvisionedProductStackSetProvisioningPreferencesArgs =
        ProvisionedProductStackSetProvisioningPreferencesArgs(
            accounts = accounts,
            failureToleranceCount = failureToleranceCount,
            failureTolerancePercentage = failureTolerancePercentage,
            maxConcurrencyCount = maxConcurrencyCount,
            maxConcurrencyPercentage = maxConcurrencyPercentage,
            regions = regions,
        )
}
