@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getAppregistryApplication.
 * @property applicationTag A map with a single tag key-value pair used to associate resources with the application.
 * @property arn ARN (Amazon Resource Name) of the application.
 * @property description Description of the application.
 * @property id
 * @property name Name of the application.
 */
public data class GetAppregistryApplicationResult(
    public val applicationTag: Map<String, String>,
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetAppregistryApplicationResult): GetAppregistryApplicationResult = GetAppregistryApplicationResult(
            applicationTag = javaType.applicationTag().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
