@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property constraintId Identifier of the constraint.
 * @property description Description of the constraint.
 * @property owner
 * @property portfolioId Portfolio identifier.
 * The following arguments are optional:
 * @property productId Product identifier.
 * @property type Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `STACKSET`, and `TEMPLATE`.
 */
public data class GetPortfolioConstraintsDetail(
    public val constraintId: String,
    public val description: String,
    public val owner: String,
    public val portfolioId: String,
    public val productId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetPortfolioConstraintsDetail): GetPortfolioConstraintsDetail = GetPortfolioConstraintsDetail(
            constraintId = javaType.constraintId(),
            description = javaType.description(),
            owner = javaType.owner(),
            portfolioId = javaType.portfolioId(),
            productId = javaType.productId(),
            type = javaType.type(),
        )
    }
}
