@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPortfolio.
 * @property acceptLanguage
 * @property arn Portfolio ARN.
 * @property createdTime Time the portfolio was created.
 * @property description Description of the portfolio
 * @property id
 * @property name Portfolio name.
 * @property providerName Name of the person or organization who owns the portfolio.
 * @property tags Tags applied to the portfolio.
 */
public data class GetPortfolioResult(
    public val acceptLanguage: String? = null,
    public val arn: String,
    public val createdTime: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val providerName: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetPortfolioResult): GetPortfolioResult = GetPortfolioResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            arn = javaType.arn(),
            createdTime = javaType.createdTime(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            providerName = javaType.providerName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
