@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getProduct.
 * @property acceptLanguage
 * @property arn ARN of the product.
 * @property createdTime Time when the product was created.
 * @property description Description of the product.
 * @property distributor Vendor of the product.
 * @property hasDefaultPath Whether the product has a default path.
 * @property id
 * @property name Name of the product.
 * @property owner Owner of the product.
 * @property status Status of the product.
 * @property supportDescription Field that provides support information about the product.
 * @property supportEmail Contact email for product support.
 * @property supportUrl Contact URL for product support.
 * @property tags Tags applied to the product.
 * @property type Type of product.
 */
public data class GetProductResult(
    public val acceptLanguage: String? = null,
    public val arn: String,
    public val createdTime: String,
    public val description: String,
    public val distributor: String,
    public val hasDefaultPath: Boolean,
    public val id: String,
    public val name: String,
    public val owner: String,
    public val status: String,
    public val supportDescription: String,
    public val supportEmail: String,
    public val supportUrl: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetProductResult): GetProductResult = GetProductResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            arn = javaType.arn(),
            createdTime = javaType.createdTime(),
            description = javaType.description(),
            distributor = javaType.distributor(),
            hasDefaultPath = javaType.hasDefaultPath(),
            id = javaType.id(),
            name = javaType.name(),
            owner = javaType.owner(),
            status = javaType.status(),
            supportDescription = javaType.supportDescription(),
            supportEmail = javaType.supportEmail(),
            supportUrl = javaType.supportUrl(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
