@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property active Indicates whether the product version is active.
 * @property createdTime The UTC time stamp of the creation time.
 * @property description The description of the provisioning artifact.
 * @property guidance Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
 * @property id The identifier of the provisioning artifact.
 * @property name The name of the provisioning artifact.
 * @property type The type of provisioning artifact.
 */
public data class GetProvisioningArtifactsProvisioningArtifactDetail(
    public val active: Boolean,
    public val createdTime: String,
    public val description: String,
    public val guidance: String,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetProvisioningArtifactsProvisioningArtifactDetail): GetProvisioningArtifactsProvisioningArtifactDetail =
            GetProvisioningArtifactsProvisioningArtifactDetail(
                active = javaType.active(),
                createdTime = javaType.createdTime(),
                description = javaType.description(),
                guidance = javaType.guidance(),
                id = javaType.id(),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
