@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Parameter key.
 * @property usePreviousValue Whether to ignore `value` and keep the previous parameter value. Ignored when initially provisioning a product.
 * @property value Parameter value.
 */
public data class ProvisionedProductProvisioningParameter(
    public val key: String,
    public val usePreviousValue: Boolean? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.ProvisionedProductProvisioningParameter): ProvisionedProductProvisioningParameter = ProvisionedProductProvisioningParameter(
            key = javaType.key(),
            usePreviousValue = javaType.usePreviousValue().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
