@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accounts One or more AWS accounts that will have access to the provisioned product. The AWS accounts specified should be within the list of accounts in the STACKSET constraint. To get the list of accounts in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all accounts from the STACKSET constraint.
 * @property failureToleranceCount Number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both. The default value is 0 if no value is specified.
 * @property failureTolerancePercentage Percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. You must specify either `failure_tolerance_count` or `failure_tolerance_percentage`, but not both.
 * @property maxConcurrencyCount Maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `failure_tolerance_count`. `max_concurrency_count` is at most one more than the `failure_tolerance_count`. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
 * @property maxConcurrencyPercentage Maximum percentage of accounts in which to perform this operation at one time. When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as 1 instead. Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling. You must specify either `max_concurrency_count` or `max_concurrency_percentage`, but not both.
 * @property regions One or more AWS Regions where the provisioned product will be available. The specified regions should be within the list of regions from the STACKSET constraint. To get the list of regions in the STACKSET constraint, use the `aws_servicecatalog_provisioning_parameters` data source. If no values are specified, the default value is all regions from the STACKSET constraint.
 */
public data class ProvisionedProductStackSetProvisioningPreferences(
    public val accounts: List<String>? = null,
    public val failureToleranceCount: Int? = null,
    public val failureTolerancePercentage: Int? = null,
    public val maxConcurrencyCount: Int? = null,
    public val maxConcurrencyPercentage: Int? = null,
    public val regions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.ProvisionedProductStackSetProvisioningPreferences): ProvisionedProductStackSetProvisioningPreferences =
            ProvisionedProductStackSetProvisioningPreferences(
                accounts = javaType.accounts().map({ args0 -> args0 }),
                failureToleranceCount = javaType.failureToleranceCount().map({ args0 -> args0 }).orElse(null),
                failureTolerancePercentage = javaType.failureTolerancePercentage().map({ args0 ->
                    args0
                }).orElse(null),
                maxConcurrencyCount = javaType.maxConcurrencyCount().map({ args0 -> args0 }).orElse(null),
                maxConcurrencyPercentage = javaType.maxConcurrencyPercentage().map({ args0 -> args0 }).orElse(null),
                regions = javaType.regions().map({ args0 -> args0 }),
            )
    }
}
