@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property assumeRole ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
 * @property name Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
 * @property parameters List of parameters in JSON format. For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
 * @property type Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
 * @property version SSM document version. For example, `1`.
 */
public data class ServiceActionDefinition(
    public val assumeRole: String? = null,
    public val name: String,
    public val parameters: String? = null,
    public val type: String? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.ServiceActionDefinition): ServiceActionDefinition = ServiceActionDefinition(
            assumeRole = javaType.assumeRole().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
