@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HttpNamespace].
 */
@PulumiTagMarker
public class HttpNamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HttpNamespaceArgs = HttpNamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HttpNamespaceArgsBuilder.() -> Unit) {
        val builder = HttpNamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HttpNamespace {
        val builtJavaResource = com.pulumi.aws.servicediscovery.HttpNamespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HttpNamespace(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicediscovery.HttpNamespace("example", {
 *     name: "development",
 *     description: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicediscovery.HttpNamespace("example",
 *     name="development",
 *     description="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceDiscovery.HttpNamespace("example", new()
 *     {
 *         Name = "development",
 *         Description = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicediscovery.NewHttpNamespace(ctx, "example", &servicediscovery.HttpNamespaceArgs{
 * 			Name:        pulumi.String("development"),
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.HttpNamespace;
 * import com.pulumi.aws.servicediscovery.HttpNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HttpNamespace("example", HttpNamespaceArgs.builder()
 *             .name("development")
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicediscovery:HttpNamespace
 *     properties:
 *       name: development
 *       description: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Discovery HTTP Namespace using the namespace ID. For example:
 * ```sh
 * $ pulumi import aws:servicediscovery/httpNamespace:HttpNamespace example ns-1234567890
 * ```
 */
public class HttpNamespace internal constructor(
    override val javaResource: com.pulumi.aws.servicediscovery.HttpNamespace,
) : KotlinCustomResource(javaResource, HttpNamespaceMapper) {
    /**
     * The ARN that Amazon Route 53 assigns to the namespace when you create it.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description that you specify for the namespace when you create it.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of an HTTP namespace.
     */
    public val httpName: Output<String>
        get() = javaResource.httpName().applyValue({ args0 -> args0 })

    /**
     * The name of the http namespace.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object HttpNamespaceMapper : ResourceMapper<HttpNamespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicediscovery.HttpNamespace::class == javaResource::class

    override fun map(javaResource: Resource): HttpNamespace = HttpNamespace(
        javaResource as
            com.pulumi.aws.servicediscovery.HttpNamespace,
    )
}

/**
 * @see [HttpNamespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HttpNamespace].
 */
public suspend fun httpNamespace(
    name: String,
    block: suspend HttpNamespaceResourceBuilder.() -> Unit,
): HttpNamespace {
    val builder = HttpNamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HttpNamespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun httpNamespace(name: String): HttpNamespace {
    val builder = HttpNamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
