@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PrivateDnsNamespace].
 */
@PulumiTagMarker
public class PrivateDnsNamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateDnsNamespaceArgs = PrivateDnsNamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateDnsNamespaceArgsBuilder.() -> Unit) {
        val builder = PrivateDnsNamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateDnsNamespace {
        val builtJavaResource =
            com.pulumi.aws.servicediscovery.PrivateDnsNamespace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateDnsNamespace(builtJavaResource)
    }
}

/**
 * Provides a Service Discovery Private DNS Namespace resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const examplePrivateDnsNamespace = new aws.servicediscovery.PrivateDnsNamespace("example", {
 *     name: "hoge.example.local",
 *     description: "example",
 *     vpc: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_private_dns_namespace = aws.servicediscovery.PrivateDnsNamespace("example",
 *     name="hoge.example.local",
 *     description="example",
 *     vpc=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var examplePrivateDnsNamespace = new Aws.ServiceDiscovery.PrivateDnsNamespace("example", new()
 *     {
 *         Name = "hoge.example.local",
 *         Description = "example",
 *         Vpc = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = servicediscovery.NewPrivateDnsNamespace(ctx, "example", &servicediscovery.PrivateDnsNamespaceArgs{
 * 			Name:        pulumi.String("hoge.example.local"),
 * 			Description: pulumi.String("example"),
 * 			Vpc:         example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var examplePrivateDnsNamespace = new PrivateDnsNamespace("examplePrivateDnsNamespace", PrivateDnsNamespaceArgs.builder()
 *             .name("hoge.example.local")
 *             .description("example")
 *             .vpc(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   examplePrivateDnsNamespace:
 *     type: aws:servicediscovery:PrivateDnsNamespace
 *     name: example
 *     properties:
 *       name: hoge.example.local
 *       description: example
 *       vpc: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Discovery Private DNS Namespace using the namespace ID and VPC ID. For example:
 * ```sh
 * $ pulumi import aws:servicediscovery/privateDnsNamespace:PrivateDnsNamespace example 0123456789:vpc-123345
 * ```
 */
public class PrivateDnsNamespace internal constructor(
    override val javaResource: com.pulumi.aws.servicediscovery.PrivateDnsNamespace,
) : KotlinCustomResource(javaResource, PrivateDnsNamespaceMapper) {
    /**
     * The ARN that Amazon Route 53 assigns to the namespace when you create it.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description that you specify for the namespace when you create it.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
     */
    public val hostedZone: Output<String>
        get() = javaResource.hostedZone().applyValue({ args0 -> args0 })

    /**
     * The name of the namespace.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of VPC that you want to associate the namespace with.
     */
    public val vpc: Output<String>
        get() = javaResource.vpc().applyValue({ args0 -> args0 })
}

public object PrivateDnsNamespaceMapper : ResourceMapper<PrivateDnsNamespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicediscovery.PrivateDnsNamespace::class == javaResource::class

    override fun map(javaResource: Resource): PrivateDnsNamespace = PrivateDnsNamespace(
        javaResource
            as com.pulumi.aws.servicediscovery.PrivateDnsNamespace,
    )
}

/**
 * @see [PrivateDnsNamespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateDnsNamespace].
 */
public suspend fun privateDnsNamespace(
    name: String,
    block: suspend PrivateDnsNamespaceResourceBuilder.() -> Unit,
): PrivateDnsNamespace {
    val builder = PrivateDnsNamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateDnsNamespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateDnsNamespace(name: String): PrivateDnsNamespace {
    val builder = PrivateDnsNamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
