@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PublicDnsNamespace].
 */
@PulumiTagMarker
public class PublicDnsNamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublicDnsNamespaceArgs = PublicDnsNamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublicDnsNamespaceArgsBuilder.() -> Unit) {
        val builder = PublicDnsNamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PublicDnsNamespace {
        val builtJavaResource =
            com.pulumi.aws.servicediscovery.PublicDnsNamespace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PublicDnsNamespace(builtJavaResource)
    }
}

/**
 * Provides a Service Discovery Public DNS Namespace resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicediscovery.PublicDnsNamespace("example", {
 *     name: "hoge.example.com",
 *     description: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicediscovery.PublicDnsNamespace("example",
 *     name="hoge.example.com",
 *     description="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceDiscovery.PublicDnsNamespace("example", new()
 *     {
 *         Name = "hoge.example.com",
 *         Description = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicediscovery.NewPublicDnsNamespace(ctx, "example", &servicediscovery.PublicDnsNamespaceArgs{
 * 			Name:        pulumi.String("hoge.example.com"),
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicDnsNamespace("example", PublicDnsNamespaceArgs.builder()
 *             .name("hoge.example.com")
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicediscovery:PublicDnsNamespace
 *     properties:
 *       name: hoge.example.com
 *       description: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Discovery Public DNS Namespace using the namespace ID. For example:
 * ```sh
 * $ pulumi import aws:servicediscovery/publicDnsNamespace:PublicDnsNamespace example 0123456789
 * ```
 */
public class PublicDnsNamespace internal constructor(
    override val javaResource: com.pulumi.aws.servicediscovery.PublicDnsNamespace,
) : KotlinCustomResource(javaResource, PublicDnsNamespaceMapper) {
    /**
     * The ARN that Amazon Route 53 assigns to the namespace when you create it.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description that you specify for the namespace when you create it.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
     */
    public val hostedZone: Output<String>
        get() = javaResource.hostedZone().applyValue({ args0 -> args0 })

    /**
     * The name of the namespace.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PublicDnsNamespaceMapper : ResourceMapper<PublicDnsNamespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicediscovery.PublicDnsNamespace::class == javaResource::class

    override fun map(javaResource: Resource): PublicDnsNamespace = PublicDnsNamespace(
        javaResource as
            com.pulumi.aws.servicediscovery.PublicDnsNamespace,
    )
}

/**
 * @see [PublicDnsNamespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublicDnsNamespace].
 */
public suspend fun publicDnsNamespace(
    name: String,
    block: suspend PublicDnsNamespaceResourceBuilder.() -> Unit,
): PublicDnsNamespace {
    val builder = PublicDnsNamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublicDnsNamespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publicDnsNamespace(name: String): PublicDnsNamespace {
    val builder = PublicDnsNamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
