@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceDnsConfig
import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceHealthCheckConfig
import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceHealthCheckCustomConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceDnsConfig.Companion.toKotlin as serviceDnsConfigToKotlin
import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceHealthCheckConfig.Companion.toKotlin as serviceHealthCheckConfigToKotlin
import com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceHealthCheckCustomConfig.Companion.toKotlin as serviceHealthCheckCustomConfigToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.aws.servicediscovery.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Provides a Service Discovery Service resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {
 *     cidrBlock: "10.0.0.0/16",
 *     enableDnsSupport: true,
 *     enableDnsHostnames: true,
 * });
 * const examplePrivateDnsNamespace = new aws.servicediscovery.PrivateDnsNamespace("example", {
 *     name: "example.mydomain.local",
 *     description: "example",
 *     vpc: example.id,
 * });
 * const exampleService = new aws.servicediscovery.Service("example", {
 *     name: "example",
 *     dnsConfig: {
 *         namespaceId: examplePrivateDnsNamespace.id,
 *         dnsRecords: [{
 *             ttl: 10,
 *             type: "A",
 *         }],
 *         routingPolicy: "MULTIVALUE",
 *     },
 *     healthCheckCustomConfig: {
 *         failureThreshold: 1,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example",
 *     cidr_block="10.0.0.0/16",
 *     enable_dns_support=True,
 *     enable_dns_hostnames=True)
 * example_private_dns_namespace = aws.servicediscovery.PrivateDnsNamespace("example",
 *     name="example.mydomain.local",
 *     description="example",
 *     vpc=example.id)
 * example_service = aws.servicediscovery.Service("example",
 *     name="example",
 *     dns_config={
 *         "namespace_id": example_private_dns_namespace.id,
 *         "dns_records": [{
 *             "ttl": 10,
 *             "type": "A",
 *         }],
 *         "routing_policy": "MULTIVALUE",
 *     },
 *     health_check_custom_config={
 *         "failure_threshold": 1,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         EnableDnsSupport = true,
 *         EnableDnsHostnames = true,
 *     });
 *     var examplePrivateDnsNamespace = new Aws.ServiceDiscovery.PrivateDnsNamespace("example", new()
 *     {
 *         Name = "example.mydomain.local",
 *         Description = "example",
 *         Vpc = example.Id,
 *     });
 *     var exampleService = new Aws.ServiceDiscovery.Service("example", new()
 *     {
 *         Name = "example",
 *         DnsConfig = new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigArgs
 *         {
 *             NamespaceId = examplePrivateDnsNamespace.Id,
 *             DnsRecords = new[]
 *             {
 *                 new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigDnsRecordArgs
 *                 {
 *                     Ttl = 10,
 *                     Type = "A",
 *                 },
 *             },
 *             RoutingPolicy = "MULTIVALUE",
 *         },
 *         HealthCheckCustomConfig = new Aws.ServiceDiscovery.Inputs.ServiceHealthCheckCustomConfigArgs
 *         {
 *             FailureThreshold = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock:          pulumi.String("10.0.0.0/16"),
 * 			EnableDnsSupport:   pulumi.Bool(true),
 * 			EnableDnsHostnames: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		examplePrivateDnsNamespace, err := servicediscovery.NewPrivateDnsNamespace(ctx, "example", &servicediscovery.PrivateDnsNamespaceArgs{
 * 			Name:        pulumi.String("example.mydomain.local"),
 * 			Description: pulumi.String("example"),
 * 			Vpc:         example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = servicediscovery.NewService(ctx, "example", &servicediscovery.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 			DnsConfig: &servicediscovery.ServiceDnsConfigArgs{
 * 				NamespaceId: examplePrivateDnsNamespace.ID(),
 * 				DnsRecords: servicediscovery.ServiceDnsConfigDnsRecordArray{
 * 					&servicediscovery.ServiceDnsConfigDnsRecordArgs{
 * 						Ttl:  pulumi.Int(10),
 * 						Type: pulumi.String("A"),
 * 					},
 * 				},
 * 				RoutingPolicy: pulumi.String("MULTIVALUE"),
 * 			},
 * 			HealthCheckCustomConfig: &servicediscovery.ServiceHealthCheckCustomConfigArgs{
 * 				FailureThreshold: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var examplePrivateDnsNamespace = new PrivateDnsNamespace("examplePrivateDnsNamespace", PrivateDnsNamespaceArgs.builder()
 *             .name("example.mydomain.local")
 *             .description("example")
 *             .vpc(example.id())
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .name("example")
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(examplePrivateDnsNamespace.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .routingPolicy("MULTIVALUE")
 *                 .build())
 *             .healthCheckCustomConfig(ServiceHealthCheckCustomConfigArgs.builder()
 *                 .failureThreshold(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       enableDnsSupport: true
 *       enableDnsHostnames: true
 *   examplePrivateDnsNamespace:
 *     type: aws:servicediscovery:PrivateDnsNamespace
 *     name: example
 *     properties:
 *       name: example.mydomain.local
 *       description: example
 *       vpc: ${example.id}
 *   exampleService:
 *     type: aws:servicediscovery:Service
 *     name: example
 *     properties:
 *       name: example
 *       dnsConfig:
 *         namespaceId: ${examplePrivateDnsNamespace.id}
 *         dnsRecords:
 *           - ttl: 10
 *             type: A
 *         routingPolicy: MULTIVALUE
 *       healthCheckCustomConfig:
 *         failureThreshold: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicediscovery.PublicDnsNamespace("example", {
 *     name: "example.mydomain.com",
 *     description: "example",
 * });
 * const exampleService = new aws.servicediscovery.Service("example", {
 *     name: "example",
 *     dnsConfig: {
 *         namespaceId: example.id,
 *         dnsRecords: [{
 *             ttl: 10,
 *             type: "A",
 *         }],
 *     },
 *     healthCheckConfig: {
 *         failureThreshold: 10,
 *         resourcePath: "path",
 *         type: "HTTP",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicediscovery.PublicDnsNamespace("example",
 *     name="example.mydomain.com",
 *     description="example")
 * example_service = aws.servicediscovery.Service("example",
 *     name="example",
 *     dns_config={
 *         "namespace_id": example.id,
 *         "dns_records": [{
 *             "ttl": 10,
 *             "type": "A",
 *         }],
 *     },
 *     health_check_config={
 *         "failure_threshold": 10,
 *         "resource_path": "path",
 *         "type": "HTTP",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceDiscovery.PublicDnsNamespace("example", new()
 *     {
 *         Name = "example.mydomain.com",
 *         Description = "example",
 *     });
 *     var exampleService = new Aws.ServiceDiscovery.Service("example", new()
 *     {
 *         Name = "example",
 *         DnsConfig = new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigArgs
 *         {
 *             NamespaceId = example.Id,
 *             DnsRecords = new[]
 *             {
 *                 new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigDnsRecordArgs
 *                 {
 *                     Ttl = 10,
 *                     Type = "A",
 *                 },
 *             },
 *         },
 *         HealthCheckConfig = new Aws.ServiceDiscovery.Inputs.ServiceHealthCheckConfigArgs
 *         {
 *             FailureThreshold = 10,
 *             ResourcePath = "path",
 *             Type = "HTTP",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := servicediscovery.NewPublicDnsNamespace(ctx, "example", &servicediscovery.PublicDnsNamespaceArgs{
 * 			Name:        pulumi.String("example.mydomain.com"),
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = servicediscovery.NewService(ctx, "example", &servicediscovery.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 			DnsConfig: &servicediscovery.ServiceDnsConfigArgs{
 * 				NamespaceId: example.ID(),
 * 				DnsRecords: servicediscovery.ServiceDnsConfigDnsRecordArray{
 * 					&servicediscovery.ServiceDnsConfigDnsRecordArgs{
 * 						Ttl:  pulumi.Int(10),
 * 						Type: pulumi.String("A"),
 * 					},
 * 				},
 * 			},
 * 			HealthCheckConfig: &servicediscovery.ServiceHealthCheckConfigArgs{
 * 				FailureThreshold: pulumi.Int(10),
 * 				ResourcePath:     pulumi.String("path"),
 * 				Type:             pulumi.String("HTTP"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicDnsNamespace("example", PublicDnsNamespaceArgs.builder()
 *             .name("example.mydomain.com")
 *             .description("example")
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .name("example")
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(example.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .build())
 *             .healthCheckConfig(ServiceHealthCheckConfigArgs.builder()
 *                 .failureThreshold(10)
 *                 .resourcePath("path")
 *                 .type("HTTP")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicediscovery:PublicDnsNamespace
 *     properties:
 *       name: example.mydomain.com
 *       description: example
 *   exampleService:
 *     type: aws:servicediscovery:Service
 *     name: example
 *     properties:
 *       name: example
 *       dnsConfig:
 *         namespaceId: ${example.id}
 *         dnsRecords:
 *           - ttl: 10
 *             type: A
 *       healthCheckConfig:
 *         failureThreshold: 10
 *         resourcePath: path
 *         type: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Discovery Service using the service ID. For example:
 * ```sh
 * $ pulumi import aws:servicediscovery/service:Service example 0123456789
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.aws.servicediscovery.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * The ARN of the service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the service.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
     */
    public val dnsConfig: Output<ServiceDnsConfig>?
        get() = javaResource.dnsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceDnsConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable. Defaults to `false`.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
     */
    public val healthCheckConfig: Output<ServiceHealthCheckConfig>?
        get() = javaResource.healthCheckConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceHealthCheckConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
     */
    public val healthCheckCustomConfig: Output<ServiceHealthCheckCustomConfig>?
        get() = javaResource.healthCheckCustomConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceHealthCheckCustomConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the service.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the namespace that you want to use to create the service.
     */
    public val namespaceId: Output<String>
        get() = javaResource.namespaceId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicediscovery.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.aws.servicediscovery.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
