@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.ServiceArgs.builder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceDnsConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceDnsConfigArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckConfigArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckCustomConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckCustomConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Service Discovery Service resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {
 *     cidrBlock: "10.0.0.0/16",
 *     enableDnsSupport: true,
 *     enableDnsHostnames: true,
 * });
 * const examplePrivateDnsNamespace = new aws.servicediscovery.PrivateDnsNamespace("example", {
 *     name: "example.mydomain.local",
 *     description: "example",
 *     vpc: example.id,
 * });
 * const exampleService = new aws.servicediscovery.Service("example", {
 *     name: "example",
 *     dnsConfig: {
 *         namespaceId: examplePrivateDnsNamespace.id,
 *         dnsRecords: [{
 *             ttl: 10,
 *             type: "A",
 *         }],
 *         routingPolicy: "MULTIVALUE",
 *     },
 *     healthCheckCustomConfig: {
 *         failureThreshold: 1,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example",
 *     cidr_block="10.0.0.0/16",
 *     enable_dns_support=True,
 *     enable_dns_hostnames=True)
 * example_private_dns_namespace = aws.servicediscovery.PrivateDnsNamespace("example",
 *     name="example.mydomain.local",
 *     description="example",
 *     vpc=example.id)
 * example_service = aws.servicediscovery.Service("example",
 *     name="example",
 *     dns_config={
 *         "namespace_id": example_private_dns_namespace.id,
 *         "dns_records": [{
 *             "ttl": 10,
 *             "type": "A",
 *         }],
 *         "routing_policy": "MULTIVALUE",
 *     },
 *     health_check_custom_config={
 *         "failure_threshold": 1,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         EnableDnsSupport = true,
 *         EnableDnsHostnames = true,
 *     });
 *     var examplePrivateDnsNamespace = new Aws.ServiceDiscovery.PrivateDnsNamespace("example", new()
 *     {
 *         Name = "example.mydomain.local",
 *         Description = "example",
 *         Vpc = example.Id,
 *     });
 *     var exampleService = new Aws.ServiceDiscovery.Service("example", new()
 *     {
 *         Name = "example",
 *         DnsConfig = new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigArgs
 *         {
 *             NamespaceId = examplePrivateDnsNamespace.Id,
 *             DnsRecords = new[]
 *             {
 *                 new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigDnsRecordArgs
 *                 {
 *                     Ttl = 10,
 *                     Type = "A",
 *                 },
 *             },
 *             RoutingPolicy = "MULTIVALUE",
 *         },
 *         HealthCheckCustomConfig = new Aws.ServiceDiscovery.Inputs.ServiceHealthCheckCustomConfigArgs
 *         {
 *             FailureThreshold = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock:          pulumi.String("10.0.0.0/16"),
 * 			EnableDnsSupport:   pulumi.Bool(true),
 * 			EnableDnsHostnames: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		examplePrivateDnsNamespace, err := servicediscovery.NewPrivateDnsNamespace(ctx, "example", &servicediscovery.PrivateDnsNamespaceArgs{
 * 			Name:        pulumi.String("example.mydomain.local"),
 * 			Description: pulumi.String("example"),
 * 			Vpc:         example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = servicediscovery.NewService(ctx, "example", &servicediscovery.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 			DnsConfig: &servicediscovery.ServiceDnsConfigArgs{
 * 				NamespaceId: examplePrivateDnsNamespace.ID(),
 * 				DnsRecords: servicediscovery.ServiceDnsConfigDnsRecordArray{
 * 					&servicediscovery.ServiceDnsConfigDnsRecordArgs{
 * 						Ttl:  pulumi.Int(10),
 * 						Type: pulumi.String("A"),
 * 					},
 * 				},
 * 				RoutingPolicy: pulumi.String("MULTIVALUE"),
 * 			},
 * 			HealthCheckCustomConfig: &servicediscovery.ServiceHealthCheckCustomConfigArgs{
 * 				FailureThreshold: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var examplePrivateDnsNamespace = new PrivateDnsNamespace("examplePrivateDnsNamespace", PrivateDnsNamespaceArgs.builder()
 *             .name("example.mydomain.local")
 *             .description("example")
 *             .vpc(example.id())
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .name("example")
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(examplePrivateDnsNamespace.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .routingPolicy("MULTIVALUE")
 *                 .build())
 *             .healthCheckCustomConfig(ServiceHealthCheckCustomConfigArgs.builder()
 *                 .failureThreshold(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       enableDnsSupport: true
 *       enableDnsHostnames: true
 *   examplePrivateDnsNamespace:
 *     type: aws:servicediscovery:PrivateDnsNamespace
 *     name: example
 *     properties:
 *       name: example.mydomain.local
 *       description: example
 *       vpc: ${example.id}
 *   exampleService:
 *     type: aws:servicediscovery:Service
 *     name: example
 *     properties:
 *       name: example
 *       dnsConfig:
 *         namespaceId: ${examplePrivateDnsNamespace.id}
 *         dnsRecords:
 *           - ttl: 10
 *             type: A
 *         routingPolicy: MULTIVALUE
 *       healthCheckCustomConfig:
 *         failureThreshold: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicediscovery.PublicDnsNamespace("example", {
 *     name: "example.mydomain.com",
 *     description: "example",
 * });
 * const exampleService = new aws.servicediscovery.Service("example", {
 *     name: "example",
 *     dnsConfig: {
 *         namespaceId: example.id,
 *         dnsRecords: [{
 *             ttl: 10,
 *             type: "A",
 *         }],
 *     },
 *     healthCheckConfig: {
 *         failureThreshold: 10,
 *         resourcePath: "path",
 *         type: "HTTP",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicediscovery.PublicDnsNamespace("example",
 *     name="example.mydomain.com",
 *     description="example")
 * example_service = aws.servicediscovery.Service("example",
 *     name="example",
 *     dns_config={
 *         "namespace_id": example.id,
 *         "dns_records": [{
 *             "ttl": 10,
 *             "type": "A",
 *         }],
 *     },
 *     health_check_config={
 *         "failure_threshold": 10,
 *         "resource_path": "path",
 *         "type": "HTTP",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceDiscovery.PublicDnsNamespace("example", new()
 *     {
 *         Name = "example.mydomain.com",
 *         Description = "example",
 *     });
 *     var exampleService = new Aws.ServiceDiscovery.Service("example", new()
 *     {
 *         Name = "example",
 *         DnsConfig = new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigArgs
 *         {
 *             NamespaceId = example.Id,
 *             DnsRecords = new[]
 *             {
 *                 new Aws.ServiceDiscovery.Inputs.ServiceDnsConfigDnsRecordArgs
 *                 {
 *                     Ttl = 10,
 *                     Type = "A",
 *                 },
 *             },
 *         },
 *         HealthCheckConfig = new Aws.ServiceDiscovery.Inputs.ServiceHealthCheckConfigArgs
 *         {
 *             FailureThreshold = 10,
 *             ResourcePath = "path",
 *             Type = "HTTP",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicediscovery"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := servicediscovery.NewPublicDnsNamespace(ctx, "example", &servicediscovery.PublicDnsNamespaceArgs{
 * 			Name:        pulumi.String("example.mydomain.com"),
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = servicediscovery.NewService(ctx, "example", &servicediscovery.ServiceArgs{
 * 			Name: pulumi.String("example"),
 * 			DnsConfig: &servicediscovery.ServiceDnsConfigArgs{
 * 				NamespaceId: example.ID(),
 * 				DnsRecords: servicediscovery.ServiceDnsConfigDnsRecordArray{
 * 					&servicediscovery.ServiceDnsConfigDnsRecordArgs{
 * 						Ttl:  pulumi.Int(10),
 * 						Type: pulumi.String("A"),
 * 					},
 * 				},
 * 			},
 * 			HealthCheckConfig: &servicediscovery.ServiceHealthCheckConfigArgs{
 * 				FailureThreshold: pulumi.Int(10),
 * 				ResourcePath:     pulumi.String("path"),
 * 				Type:             pulumi.String("HTTP"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PublicDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicDnsNamespace("example", PublicDnsNamespaceArgs.builder()
 *             .name("example.mydomain.com")
 *             .description("example")
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .name("example")
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(example.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .build())
 *             .healthCheckConfig(ServiceHealthCheckConfigArgs.builder()
 *                 .failureThreshold(10)
 *                 .resourcePath("path")
 *                 .type("HTTP")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicediscovery:PublicDnsNamespace
 *     properties:
 *       name: example.mydomain.com
 *       description: example
 *   exampleService:
 *     type: aws:servicediscovery:Service
 *     name: example
 *     properties:
 *       name: example
 *       dnsConfig:
 *         namespaceId: ${example.id}
 *         dnsRecords:
 *           - ttl: 10
 *             type: A
 *       healthCheckConfig:
 *         failureThreshold: 10
 *         resourcePath: path
 *         type: HTTP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Discovery Service using the service ID. For example:
 * ```sh
 * $ pulumi import aws:servicediscovery/service:Service example 0123456789
 * ```
 * @property description The description of the service.
 * @property dnsConfig A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
 * @property forceDestroy A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable. Defaults to `false`.
 * @property healthCheckConfig A complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
 * @property healthCheckCustomConfig A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
 * @property name The name of the service.
 * @property namespaceId The ID of the namespace that you want to use to create the service.
 * @property tags A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
 */
public data class ServiceArgs(
    public val description: Output<String>? = null,
    public val dnsConfig: Output<ServiceDnsConfigArgs>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val healthCheckConfig: Output<ServiceHealthCheckConfigArgs>? = null,
    public val healthCheckCustomConfig: Output<ServiceHealthCheckCustomConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.ServiceArgs =
        com.pulumi.aws.servicediscovery.ServiceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsConfig(dnsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthCheckCustomConfig(
                healthCheckCustomConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dnsConfig: Output<ServiceDnsConfigArgs>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var healthCheckConfig: Output<ServiceHealthCheckConfigArgs>? = null

    private var healthCheckCustomConfig: Output<ServiceHealthCheckCustomConfigArgs>? = null

    private var name: Output<String>? = null

    private var namespaceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the service.
     */
    @JvmName("jwmcxuufsrxvkqtt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
     */
    @JvmName("xcrwjyrcokvqndlo")
    public suspend fun dnsConfig(`value`: Output<ServiceDnsConfigArgs>) {
        this.dnsConfig = value
    }

    /**
     * @param value A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable. Defaults to `false`.
     */
    @JvmName("rcdmxhkvlaimvowl")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value A complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
     */
    @JvmName("bledkkwwsnlajqxp")
    public suspend fun healthCheckConfig(`value`: Output<ServiceHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
     */
    @JvmName("lccprvaisoxihksc")
    public suspend fun healthCheckCustomConfig(`value`: Output<ServiceHealthCheckCustomConfigArgs>) {
        this.healthCheckCustomConfig = value
    }

    /**
     * @param value The name of the service.
     */
    @JvmName("xptcbsgmkftdcpol")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the namespace that you want to use to create the service.
     */
    @JvmName("xrxqkvvtydsdeqwg")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jkaksqeixlhqrahy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    @JvmName("kvpqakqxqbnbikam")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the service.
     */
    @JvmName("hydpmfxnjodmnwag")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
     */
    @JvmName("gbmbnxcvcpjvrhxw")
    public suspend fun dnsConfig(`value`: ServiceDnsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsConfig = mapped
    }

    /**
     * @param argument A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
     */
    @JvmName("satcnxutcafbsaqp")
    public suspend fun dnsConfig(argument: suspend ServiceDnsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDnsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsConfig = mapped
    }

    /**
     * @param value A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable. Defaults to `false`.
     */
    @JvmName("xaupisqpasslgsgn")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value A complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
     */
    @JvmName("ovpuyfmntyfvwulw")
    public suspend fun healthCheckConfig(`value`: ServiceHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument A complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
     */
    @JvmName("mpskpcbnuilntuda")
    public suspend fun healthCheckConfig(argument: suspend ServiceHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceHealthCheckConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
     */
    @JvmName("dsamtfysiypxvqhe")
    public suspend fun healthCheckCustomConfig(`value`: ServiceHealthCheckCustomConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckCustomConfig = mapped
    }

    /**
     * @param argument A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
     */
    @JvmName("lqcrercillkmcvcg")
    public suspend fun healthCheckCustomConfig(argument: suspend ServiceHealthCheckCustomConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceHealthCheckCustomConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckCustomConfig = mapped
    }

    /**
     * @param value The name of the service.
     */
    @JvmName("kktqjndlaqedpfuk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the namespace that you want to use to create the service.
     */
    @JvmName("kpqrqxyxodhvqafr")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rawpvaoigqxipjks")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rixxnucafdnaeial")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    @JvmName("hogovklvkxvrqadp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        description = description,
        dnsConfig = dnsConfig,
        forceDestroy = forceDestroy,
        healthCheckConfig = healthCheckConfig,
        healthCheckCustomConfig = healthCheckCustomConfig,
        name = name,
        namespaceId = namespaceId,
        tags = tags,
        type = type,
    )
}
