@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.GetDnsNamespacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDnsNamespace.
 * @property name Name of the namespace.
 * @property tags Map of tags for the resource.
 * @property type Type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
 */
public data class GetDnsNamespacePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.GetDnsNamespacePlainArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.GetDnsNamespacePlainArgs =
        com.pulumi.aws.servicediscovery.inputs.GetDnsNamespacePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDnsNamespacePlainArgs].
 */
@PulumiTagMarker
public class GetDnsNamespacePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    /**
     * @param value Name of the namespace.
     */
    @JvmName("hlixioyccdbmhiuv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("navsnnfskxiosikv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("fpkqwmlymveecydp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
     */
    @JvmName("wgyjxocfwbxgyvhk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetDnsNamespacePlainArgs = GetDnsNamespacePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
