@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property name Name of the service.
 * @property namespaceId ID of the namespace that the service belongs to.
 * @property tags Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tagsAll (**Deprecated**) Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 */
public data class GetServicePlainArgs(
    public val name: String,
    public val namespaceId: String,
    public val tags: Map<String, String>? = null,
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val tagsAll: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.GetServicePlainArgs =
        com.pulumi.aws.servicediscovery.inputs.GetServicePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .namespaceId(namespaceId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tagsAll(tagsAll?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var namespaceId: String? = null

    private var tags: Map<String, String>? = null

    private var tagsAll: Map<String, String>? = null

    /**
     * @param value Name of the service.
     */
    @JvmName("gufjmpmwsfejhfrh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ID of the namespace that the service belongs to.
     */
    @JvmName("yqqrawwwhnsmujnq")
    public suspend fun namespaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceId = mapped
    }

    /**
     * @param value Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kfcyaauvssgplpcf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hplasfwhtgseylno")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value (**Deprecated**) Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("lujvrwusbpimuota")
    public suspend fun tagsAll(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagsAll = mapped
    }

    /**
     * @param values (**Deprecated**) Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("sdgmxqwoesqlbqwo")
    public fun tagsAll(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagsAll = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        namespaceId = namespaceId ?: throw PulumiNullFieldException("namespaceId"),
        tags = tags,
        tagsAll = tagsAll,
    )
}
