@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsRecords An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
 * @property namespaceId The ID of the namespace to use for DNS configuration.
 * @property routingPolicy The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
 */
public data class ServiceDnsConfigArgs(
    public val dnsRecords: Output<List<ServiceDnsConfigDnsRecordArgs>>,
    public val namespaceId: Output<String>,
    public val routingPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs =
        com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs.builder()
            .dnsRecords(
                dnsRecords.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespaceId(namespaceId.applyValue({ args0 -> args0 }))
            .routingPolicy(routingPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceDnsConfigArgs].
 */
@PulumiTagMarker
public class ServiceDnsConfigArgsBuilder internal constructor() {
    private var dnsRecords: Output<List<ServiceDnsConfigDnsRecordArgs>>? = null

    private var namespaceId: Output<String>? = null

    private var routingPolicy: Output<String>? = null

    /**
     * @param value An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("hafjketgnkcjwygn")
    public suspend fun dnsRecords(`value`: Output<List<ServiceDnsConfigDnsRecordArgs>>) {
        this.dnsRecords = value
    }

    @JvmName("gbgankvgkiuitkcb")
    public suspend fun dnsRecords(vararg values: Output<ServiceDnsConfigDnsRecordArgs>) {
        this.dnsRecords = Output.all(values.asList())
    }

    /**
     * @param values An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("wylmmfgavuicchty")
    public suspend fun dnsRecords(values: List<Output<ServiceDnsConfigDnsRecordArgs>>) {
        this.dnsRecords = Output.all(values)
    }

    /**
     * @param value The ID of the namespace to use for DNS configuration.
     */
    @JvmName("bcnbscshpcopfyqh")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
     */
    @JvmName("wctgiiveuayuunbb")
    public suspend fun routingPolicy(`value`: Output<String>) {
        this.routingPolicy = value
    }

    /**
     * @param value An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("mrgavkqlplnieftq")
    public suspend fun dnsRecords(`value`: List<ServiceDnsConfigDnsRecordArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsRecords = mapped
    }

    /**
     * @param argument An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("firpcommspiwsvqv")
    public suspend fun dnsRecords(argument: List<suspend ServiceDnsConfigDnsRecordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceDnsConfigDnsRecordArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsRecords = mapped
    }

    /**
     * @param argument An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("yyjujgxmvogogdqo")
    public suspend fun dnsRecords(vararg argument: suspend ServiceDnsConfigDnsRecordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceDnsConfigDnsRecordArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsRecords = mapped
    }

    /**
     * @param argument An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("hdfghnoqkxkyvsro")
    public suspend fun dnsRecords(argument: suspend ServiceDnsConfigDnsRecordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceDnsConfigDnsRecordArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dnsRecords = mapped
    }

    /**
     * @param values An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
     */
    @JvmName("kwcahhdvouksnses")
    public suspend fun dnsRecords(vararg values: ServiceDnsConfigDnsRecordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsRecords = mapped
    }

    /**
     * @param value The ID of the namespace to use for DNS configuration.
     */
    @JvmName("ghrkyaoloqlorcgr")
    public suspend fun namespaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
     */
    @JvmName("cfeulolpwpasbsow")
    public suspend fun routingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingPolicy = mapped
    }

    internal fun build(): ServiceDnsConfigArgs = ServiceDnsConfigArgs(
        dnsRecords = dnsRecords ?: throw PulumiNullFieldException("dnsRecords"),
        namespaceId = namespaceId ?: throw PulumiNullFieldException("namespaceId"),
        routingPolicy = routingPolicy,
    )
}
