@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigDnsRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ttl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
 * @property type The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
 */
public data class ServiceDnsConfigDnsRecordArgs(
    public val ttl: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigDnsRecordArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigDnsRecordArgs =
        com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigDnsRecordArgs.builder()
            .ttl(ttl.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceDnsConfigDnsRecordArgs].
 */
@PulumiTagMarker
public class ServiceDnsConfigDnsRecordArgsBuilder internal constructor() {
    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
     */
    @JvmName("jloynsnwwhxccqwt")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
     */
    @JvmName("flrsugovnttjbvct")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
     */
    @JvmName("vvajaxoeebjlorrj")
    public suspend fun ttl(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
     */
    @JvmName("fcxadpdjmjikajjd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceDnsConfigDnsRecordArgs = ServiceDnsConfigDnsRecordArgs(
        ttl = ttl ?: throw PulumiNullFieldException("ttl"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
