@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getDnsNamespace.
 * @property arn ARN of the namespace.
 * @property description Description of the namespace.
 * @property hostedZone ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property tags Map of tags for the resource.
 * @property type
 */
public data class GetDnsNamespaceResult(
    public val arn: String,
    public val description: String,
    public val hostedZone: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetDnsNamespaceResult): GetDnsNamespaceResult = GetDnsNamespaceResult(
            arn = javaType.arn(),
            description = javaType.description(),
            hostedZone = javaType.hostedZone(),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
