@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsRecords An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
 * @property namespaceId ID of the namespace that the service belongs to.
 * @property routingPolicy Routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
 */
public data class GetServiceDnsConfig(
    public val dnsRecords: List<GetServiceDnsConfigDnsRecord>,
    public val namespaceId: String,
    public val routingPolicy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetServiceDnsConfig): GetServiceDnsConfig = GetServiceDnsConfig(
            dnsRecords = javaType.dnsRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceDnsConfigDnsRecord.Companion.toKotlin(args0)
                })
            }),
            namespaceId = javaType.namespaceId(),
            routingPolicy = javaType.routingPolicy(),
        )
    }
}
