@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsRecords An array that contains one DnsRecord object for each resource record set. See `dns_records` Block for details.
 * @property namespaceId The ID of the namespace to use for DNS configuration.
 * @property routingPolicy The routing policy that you want to apply to all records that Route 53 creates when you register an instance and specify the service. Valid Values: MULTIVALUE, WEIGHTED
 */
public data class ServiceDnsConfig(
    public val dnsRecords: List<ServiceDnsConfigDnsRecord>,
    public val namespaceId: String,
    public val routingPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.ServiceDnsConfig): ServiceDnsConfig = ServiceDnsConfig(
            dnsRecords = javaType.dnsRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicediscovery.kotlin.outputs.ServiceDnsConfigDnsRecord.Companion.toKotlin(args0)
                })
            }),
            namespaceId = javaType.namespaceId(),
            routingPolicy = javaType.routingPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
