@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.aws.servicequotas.ServiceQuotaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an individual Service Quota.
 * > **NOTE:** Global quotas apply to all AWS regions, but can only be accessed in `us-east-1` in the Commercial partition or `us-gov-west-1` in the GovCloud partition. In other regions, the AWS API will return the error `The request failed because the specified service does not exist.`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicequotas.ServiceQuota("example", {
 *     quotaCode: "L-F678F1CE",
 *     serviceCode: "vpc",
 *     value: 75,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicequotas.ServiceQuota("example",
 *     quota_code="L-F678F1CE",
 *     service_code="vpc",
 *     value=75)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceQuotas.ServiceQuota("example", new()
 *     {
 *         QuotaCode = "L-F678F1CE",
 *         ServiceCode = "vpc",
 *         Value = 75,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicequotas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicequotas.NewServiceQuota(ctx, "example", &servicequotas.ServiceQuotaArgs{
 * 			QuotaCode:   pulumi.String("L-F678F1CE"),
 * 			ServiceCode: pulumi.String("vpc"),
 * 			Value:       pulumi.Float64(75),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicequotas.ServiceQuota;
 * import com.pulumi.aws.servicequotas.ServiceQuotaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceQuota("example", ServiceQuotaArgs.builder()
 *             .quotaCode("L-F678F1CE")
 *             .serviceCode("vpc")
 *             .value(75)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicequotas:ServiceQuota
 *     properties:
 *       quotaCode: L-F678F1CE
 *       serviceCode: vpc
 *       value: 75
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_servicequotas_service_quota` using the service code and quota code, separated by a front slash (`/`). For example:
 * ~> __NOTE:__ This resource does not require explicit import and will assume management of an existing service quota on Pulumi resource creation.
 * ```sh
 * $ pulumi import aws:servicequotas/serviceQuota:ServiceQuota example vpc/L-F678F1CE
 * ```
 * @property quotaCode Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
 * @property serviceCode Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
 * @property value Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
 */
public data class ServiceQuotaArgs(
    public val quotaCode: Output<String>? = null,
    public val serviceCode: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.ServiceQuotaArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.ServiceQuotaArgs =
        com.pulumi.aws.servicequotas.ServiceQuotaArgs.builder()
            .quotaCode(quotaCode?.applyValue({ args0 -> args0 }))
            .serviceCode(serviceCode?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceQuotaArgs].
 */
@PulumiTagMarker
public class ServiceQuotaArgsBuilder internal constructor() {
    private var quotaCode: Output<String>? = null

    private var serviceCode: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
     */
    @JvmName("koqdkwvnwhojaymv")
    public suspend fun quotaCode(`value`: Output<String>) {
        this.quotaCode = value
    }

    /**
     * @param value Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     */
    @JvmName("qoqeputjwgadigtc")
    public suspend fun serviceCode(`value`: Output<String>) {
        this.serviceCode = value
    }

    /**
     * @param value Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
     */
    @JvmName("rbgucjbyiefrutju")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
     */
    @JvmName("vrbpllbjcgiiqdxc")
    public suspend fun quotaCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCode = mapped
    }

    /**
     * @param value Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     */
    @JvmName("aqtabrjxuipqouon")
    public suspend fun serviceCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCode = mapped
    }

    /**
     * @param value Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
     */
    @JvmName("kahrwfdasmxiyqkl")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ServiceQuotaArgs = ServiceQuotaArgs(
        quotaCode = quotaCode,
        serviceCode = serviceCode,
        `value` = `value`,
    )
}
