@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Template].
 */
@PulumiTagMarker
public class TemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArgs = TemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArgsBuilder.() -> Unit) {
        val builder = TemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Template {
        val builtJavaResource = com.pulumi.aws.servicequotas.Template(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Template(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Service Quotas Template.
 * > Only the management account of an organization can alter Service Quota templates, and this must be done from the `us-east-1` region.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicequotas.Template("example", {
 *     region: "us-east-1",
 *     quotaCode: "L-2ACBD22F",
 *     serviceCode: "lambda",
 *     value: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicequotas.Template("example",
 *     region="us-east-1",
 *     quota_code="L-2ACBD22F",
 *     service_code="lambda",
 *     value=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceQuotas.Template("example", new()
 *     {
 *         Region = "us-east-1",
 *         QuotaCode = "L-2ACBD22F",
 *         ServiceCode = "lambda",
 *         Value = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicequotas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicequotas.NewTemplate(ctx, "example", &servicequotas.TemplateArgs{
 * 			Region:      pulumi.String("us-east-1"),
 * 			QuotaCode:   pulumi.String("L-2ACBD22F"),
 * 			ServiceCode: pulumi.String("lambda"),
 * 			Value:       pulumi.Float64(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicequotas.Template;
 * import com.pulumi.aws.servicequotas.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .region("us-east-1")
 *             .quotaCode("L-2ACBD22F")
 *             .serviceCode("lambda")
 *             .value("80")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicequotas:Template
 *     properties:
 *       region: us-east-1
 *       quotaCode: L-2ACBD22F
 *       serviceCode: lambda
 *       value: '80'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Quotas Template using the `id`. For example:
 * ```sh
 * $ pulumi import aws:servicequotas/template:Template example us-east-1,L-2ACBD22F,lambda
 * ```
 */
public class Template internal constructor(
    override val javaResource: com.pulumi.aws.servicequotas.Template,
) : KotlinCustomResource(javaResource, TemplateMapper) {
    /**
     * Indicates whether the quota is global.
     */
    public val globalQuota: Output<Boolean>
        get() = javaResource.globalQuota().applyValue({ args0 -> args0 })

    /**
     * Quota identifier. To find the quota code for a specific quota, use the aws.servicequotas.ServiceQuota data source.
     */
    public val quotaCode: Output<String>
        get() = javaResource.quotaCode().applyValue({ args0 -> args0 })

    /**
     * Quota name.
     */
    public val quotaName: Output<String>
        get() = javaResource.quotaName().applyValue({ args0 -> args0 })

    /**
     * AWS Region to which the template applies.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * Service identifier. To find the service code value for an AWS service, use the aws.servicequotas.getService data source.
     */
    public val serviceCode: Output<String>
        get() = javaResource.serviceCode().applyValue({ args0 -> args0 })

    /**
     * Service name.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * Unit of measurement.
     */
    public val unit: Output<String>
        get() = javaResource.unit().applyValue({ args0 -> args0 })

    /**
     * The new, increased value for the quota.
     */
    public val `value`: Output<Double>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object TemplateMapper : ResourceMapper<Template> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicequotas.Template::class == javaResource::class

    override fun map(javaResource: Resource): Template = Template(
        javaResource as
            com.pulumi.aws.servicequotas.Template,
    )
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Template].
 */
public suspend fun template(name: String, block: suspend TemplateResourceBuilder.() -> Unit): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 */
public fun template(name: String): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
