@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.aws.servicequotas.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Service Quotas Template.
 * > Only the management account of an organization can alter Service Quota templates, and this must be done from the `us-east-1` region.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.servicequotas.Template("example", {
 *     region: "us-east-1",
 *     quotaCode: "L-2ACBD22F",
 *     serviceCode: "lambda",
 *     value: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.servicequotas.Template("example",
 *     region="us-east-1",
 *     quota_code="L-2ACBD22F",
 *     service_code="lambda",
 *     value=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ServiceQuotas.Template("example", new()
 *     {
 *         Region = "us-east-1",
 *         QuotaCode = "L-2ACBD22F",
 *         ServiceCode = "lambda",
 *         Value = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/servicequotas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicequotas.NewTemplate(ctx, "example", &servicequotas.TemplateArgs{
 * 			Region:      pulumi.String("us-east-1"),
 * 			QuotaCode:   pulumi.String("L-2ACBD22F"),
 * 			ServiceCode: pulumi.String("lambda"),
 * 			Value:       pulumi.Float64(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicequotas.Template;
 * import com.pulumi.aws.servicequotas.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .region("us-east-1")
 *             .quotaCode("L-2ACBD22F")
 *             .serviceCode("lambda")
 *             .value("80")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:servicequotas:Template
 *     properties:
 *       region: us-east-1
 *       quotaCode: L-2ACBD22F
 *       serviceCode: lambda
 *       value: '80'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Service Quotas Template using the `id`. For example:
 * ```sh
 * $ pulumi import aws:servicequotas/template:Template example us-east-1,L-2ACBD22F,lambda
 * ```
 * @property quotaCode Quota identifier. To find the quota code for a specific quota, use the aws.servicequotas.ServiceQuota data source.
 * @property region AWS Region to which the template applies.
 * @property serviceCode Service identifier. To find the service code value for an AWS service, use the aws.servicequotas.getService data source.
 * @property value The new, increased value for the quota.
 */
public data class TemplateArgs(
    public val quotaCode: Output<String>? = null,
    public val region: Output<String>? = null,
    public val serviceCode: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.TemplateArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.TemplateArgs =
        com.pulumi.aws.servicequotas.TemplateArgs.builder()
            .quotaCode(quotaCode?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .serviceCode(serviceCode?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var quotaCode: Output<String>? = null

    private var region: Output<String>? = null

    private var serviceCode: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value Quota identifier. To find the quota code for a specific quota, use the aws.servicequotas.ServiceQuota data source.
     */
    @JvmName("lofvetihjyqvvxwa")
    public suspend fun quotaCode(`value`: Output<String>) {
        this.quotaCode = value
    }

    /**
     * @param value AWS Region to which the template applies.
     */
    @JvmName("huvynmdjxmjwmkyr")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Service identifier. To find the service code value for an AWS service, use the aws.servicequotas.getService data source.
     */
    @JvmName("wwnnffsjouefqspg")
    public suspend fun serviceCode(`value`: Output<String>) {
        this.serviceCode = value
    }

    /**
     * @param value The new, increased value for the quota.
     */
    @JvmName("pjkbqmrbpwdnmfnw")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value Quota identifier. To find the quota code for a specific quota, use the aws.servicequotas.ServiceQuota data source.
     */
    @JvmName("phsmsofulgsxklji")
    public suspend fun quotaCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCode = mapped
    }

    /**
     * @param value AWS Region to which the template applies.
     */
    @JvmName("ebghynvdkglaxcda")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Service identifier. To find the service code value for an AWS service, use the aws.servicequotas.getService data source.
     */
    @JvmName("jfwahuygrwcngeoc")
    public suspend fun serviceCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCode = mapped
    }

    /**
     * @param value The new, increased value for the quota.
     */
    @JvmName("elkngqivhwavhhrd")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        quotaCode = quotaCode,
        region = region,
        serviceCode = serviceCode,
        `value` = `value`,
    )
}
