@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.inputs

import com.pulumi.aws.servicequotas.inputs.GetTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTemplates.
 * @property region AWS Region to which the quota increases apply.
 * @property templates A list of quota increase templates for specified region. See `templates`.
 */
public data class GetTemplatesPlainArgs(
    public val region: String,
    public val templates: List<GetTemplatesTemplate>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.inputs.GetTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.inputs.GetTemplatesPlainArgs =
        com.pulumi.aws.servicequotas.inputs.GetTemplatesPlainArgs.builder()
            .region(region.let({ args0 -> args0 }))
            .templates(
                templates?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetTemplatesPlainArgsBuilder internal constructor() {
    private var region: String? = null

    private var templates: List<GetTemplatesTemplate>? = null

    /**
     * @param value AWS Region to which the quota increases apply.
     */
    @JvmName("owgmgtovxglrvpij")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value A list of quota increase templates for specified region. See `templates`.
     */
    @JvmName("oiwoyqqnpjlxxbbf")
    public suspend fun templates(`value`: List<GetTemplatesTemplate>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templates = mapped
    }

    /**
     * @param argument A list of quota increase templates for specified region. See `templates`.
     */
    @JvmName("gcshfpibsudelcmv")
    public suspend fun templates(argument: List<suspend GetTemplatesTemplateBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTemplatesTemplateBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.templates = mapped
    }

    /**
     * @param argument A list of quota increase templates for specified region. See `templates`.
     */
    @JvmName("tbfmtaqofmvxaqgu")
    public suspend fun templates(vararg argument: suspend GetTemplatesTemplateBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetTemplatesTemplateBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.templates = mapped
    }

    /**
     * @param argument A list of quota increase templates for specified region. See `templates`.
     */
    @JvmName("fbafpmaijhuoptms")
    public suspend fun templates(argument: suspend GetTemplatesTemplateBuilder.() -> Unit) {
        val toBeMapped = listOf(GetTemplatesTemplateBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.templates = mapped
    }

    /**
     * @param values A list of quota increase templates for specified region. See `templates`.
     */
    @JvmName("yohohpmsshclycrm")
    public suspend fun templates(vararg values: GetTemplatesTemplate) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templates = mapped
    }

    internal fun build(): GetTemplatesPlainArgs = GetTemplatesPlainArgs(
        region = region ?: throw PulumiNullFieldException("region"),
        templates = templates,
    )
}
