@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServiceQuota.
 * @property adjustable Whether the service quota is adjustable.
 * @property arn ARN of the service quota.
 * @property defaultValue Default value of the service quota.
 * @property globalQuota Whether the service quota is global for the AWS account.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property quotaCode
 * @property quotaName
 * @property serviceCode
 * @property serviceName Name of the service.
 * @property usageMetrics Information about the measurement.
 * @property value Current value of the service quota.
 */
public data class GetServiceQuotaResult(
    public val adjustable: Boolean,
    public val arn: String,
    public val defaultValue: Double,
    public val globalQuota: Boolean,
    public val id: String,
    public val quotaCode: String,
    public val quotaName: String,
    public val serviceCode: String,
    public val serviceName: String,
    public val usageMetrics: List<GetServiceQuotaUsageMetric>,
    public val `value`: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.GetServiceQuotaResult): GetServiceQuotaResult = GetServiceQuotaResult(
            adjustable = javaType.adjustable(),
            arn = javaType.arn(),
            defaultValue = javaType.defaultValue(),
            globalQuota = javaType.globalQuota(),
            id = javaType.id(),
            quotaCode = javaType.quotaCode(),
            quotaName = javaType.quotaName(),
            serviceCode = javaType.serviceCode(),
            serviceName = javaType.serviceName(),
            usageMetrics = javaType.usageMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceQuotaUsageMetric.Companion.toKotlin(args0)
                })
            }),
            `value` = javaType.`value`(),
        )
    }
}
