@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property metricDimensions The metric dimensions.
 * @property metricName The name of the metric.
 * @property metricNamespace The namespace of the metric.
 * @property metricStatisticRecommendation The metric statistic that AWS recommend you use when determining quota usage.
 */
public data class GetServiceQuotaUsageMetric(
    public val metricDimensions: List<GetServiceQuotaUsageMetricMetricDimension>,
    public val metricName: String,
    public val metricNamespace: String,
    public val metricStatisticRecommendation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.GetServiceQuotaUsageMetric): GetServiceQuotaUsageMetric = GetServiceQuotaUsageMetric(
            metricDimensions = javaType.metricDimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceQuotaUsageMetricMetricDimension.Companion.toKotlin(args0)
                })
            }),
            metricName = javaType.metricName(),
            metricNamespace = javaType.metricNamespace(),
            metricStatisticRecommendation = javaType.metricStatisticRecommendation(),
        )
    }
}
