@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTemplates.
 * @property id
 * @property region AWS Region to which the template applies.
 * @property templates A list of quota increase templates for specified region. See `templates`.
 */
public data class GetTemplatesResult(
    public val id: String,
    public val region: String,
    public val templates: List<GetTemplatesTemplate>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.GetTemplatesResult): GetTemplatesResult = GetTemplatesResult(
            id = javaType.id(),
            region = javaType.region(),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicequotas.kotlin.outputs.GetTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
