@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property globalQuota Indicates whether the quota is global.
 * @property quotaCode Quota identifier.
 * @property quotaName Quota name.
 * @property region AWS Region to which the quota increases apply.
 * @property serviceCode (Required) Service identifier.
 * @property serviceName Service name.
 * @property unit Unit of measurement.
 * @property value (Required) The new, increased value for the quota.
 */
public data class GetTemplatesTemplate(
    public val globalQuota: Boolean,
    public val quotaCode: String,
    public val quotaName: String,
    public val region: String,
    public val serviceCode: String,
    public val serviceName: String,
    public val unit: String,
    public val `value`: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.GetTemplatesTemplate): GetTemplatesTemplate = GetTemplatesTemplate(
            globalQuota = javaType.globalQuota(),
            quotaCode = javaType.quotaCode(),
            quotaName = javaType.quotaName(),
            region = javaType.region(),
            serviceCode = javaType.serviceCode(),
            serviceName = javaType.serviceName(),
            unit = javaType.unit(),
            `value` = javaType.`value`(),
        )
    }
}
