@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property metricDimensions The metric dimensions.
 * @property metricName The name of the metric.
 * @property metricNamespace The namespace of the metric.
 * @property metricStatisticRecommendation The metric statistic that AWS recommend you use when determining quota usage.
 */
public data class ServiceQuotaUsageMetric(
    public val metricDimensions: List<ServiceQuotaUsageMetricMetricDimension>? = null,
    public val metricName: String? = null,
    public val metricNamespace: String? = null,
    public val metricStatisticRecommendation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.ServiceQuotaUsageMetric): ServiceQuotaUsageMetric = ServiceQuotaUsageMetric(
            metricDimensions = javaType.metricDimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicequotas.kotlin.outputs.ServiceQuotaUsageMetricMetricDimension.Companion.toKotlin(args0)
                })
            }),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            metricNamespace = javaType.metricNamespace().map({ args0 -> args0 }).orElse(null),
            metricStatisticRecommendation = javaType.metricStatisticRecommendation().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
