@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ConfigurationSetArgs.builder
import com.pulumi.aws.ses.kotlin.inputs.ConfigurationSetDeliveryOptionsArgs
import com.pulumi.aws.ses.kotlin.inputs.ConfigurationSetDeliveryOptionsArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ConfigurationSetTrackingOptionsArgs
import com.pulumi.aws.ses.kotlin.inputs.ConfigurationSetTrackingOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an SES configuration set resource.
 * ## Example Usage
 * ### Basic Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ses.ConfigurationSet("test", {name: "some-configuration-set-test"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ses.ConfigurationSet("test", name="some-configuration-set-test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ses.ConfigurationSet("test", new()
 *     {
 *         Name = "some-configuration-set-test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewConfigurationSet(ctx, "test", &ses.ConfigurationSetArgs{
 * 			Name: pulumi.String("some-configuration-set-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ConfigurationSet;
 * import com.pulumi.aws.ses.ConfigurationSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ConfigurationSet("test", ConfigurationSetArgs.builder()
 *             .name("some-configuration-set-test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ses:ConfigurationSet
 *     properties:
 *       name: some-configuration-set-test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Require TLS Connections
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ses.ConfigurationSet("test", {
 *     name: "some-configuration-set-test",
 *     deliveryOptions: {
 *         tlsPolicy: "Require",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ses.ConfigurationSet("test",
 *     name="some-configuration-set-test",
 *     delivery_options={
 *         "tls_policy": "Require",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ses.ConfigurationSet("test", new()
 *     {
 *         Name = "some-configuration-set-test",
 *         DeliveryOptions = new Aws.Ses.Inputs.ConfigurationSetDeliveryOptionsArgs
 *         {
 *             TlsPolicy = "Require",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewConfigurationSet(ctx, "test", &ses.ConfigurationSetArgs{
 * 			Name: pulumi.String("some-configuration-set-test"),
 * 			DeliveryOptions: &ses.ConfigurationSetDeliveryOptionsArgs{
 * 				TlsPolicy: pulumi.String("Require"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ConfigurationSet;
 * import com.pulumi.aws.ses.ConfigurationSetArgs;
 * import com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ConfigurationSet("test", ConfigurationSetArgs.builder()
 *             .name("some-configuration-set-test")
 *             .deliveryOptions(ConfigurationSetDeliveryOptionsArgs.builder()
 *                 .tlsPolicy("Require")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ses:ConfigurationSet
 *     properties:
 *       name: some-configuration-set-test
 *       deliveryOptions:
 *         tlsPolicy: Require
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Tracking Options
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.ses.ConfigurationSet("test", {
 *     name: "some-configuration-set-test",
 *     trackingOptions: {
 *         customRedirectDomain: "sub.example.com",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ses.ConfigurationSet("test",
 *     name="some-configuration-set-test",
 *     tracking_options={
 *         "custom_redirect_domain": "sub.example.com",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Ses.ConfigurationSet("test", new()
 *     {
 *         Name = "some-configuration-set-test",
 *         TrackingOptions = new Aws.Ses.Inputs.ConfigurationSetTrackingOptionsArgs
 *         {
 *             CustomRedirectDomain = "sub.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewConfigurationSet(ctx, "test", &ses.ConfigurationSetArgs{
 * 			Name: pulumi.String("some-configuration-set-test"),
 * 			TrackingOptions: &ses.ConfigurationSetTrackingOptionsArgs{
 * 				CustomRedirectDomain: pulumi.String("sub.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ConfigurationSet;
 * import com.pulumi.aws.ses.ConfigurationSetArgs;
 * import com.pulumi.aws.ses.inputs.ConfigurationSetTrackingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ConfigurationSet("test", ConfigurationSetArgs.builder()
 *             .name("some-configuration-set-test")
 *             .trackingOptions(ConfigurationSetTrackingOptionsArgs.builder()
 *                 .customRedirectDomain("sub.example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:ses:ConfigurationSet
 *     properties:
 *       name: some-configuration-set-test
 *       trackingOptions:
 *         customRedirectDomain: sub.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES Configuration Sets using their `name`. For example:
 * ```sh
 * $ pulumi import aws:ses/configurationSet:ConfigurationSet test some-configuration-set-test
 * ```
 * @property deliveryOptions Whether messages that use the configuration set are required to use TLS. See below.
 * @property name Name of the configuration set.
 * The following argument is optional:
 * @property reputationMetricsEnabled Whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch. The default value is `false`.
 * @property sendingEnabled Whether email sending is enabled or disabled for the configuration set. The default value is `true`.
 * @property trackingOptions Domain that is used to redirect email recipients to an Amazon SES-operated domain. See below. **NOTE:** This functionality is best effort.
 */
public data class ConfigurationSetArgs(
    public val deliveryOptions: Output<ConfigurationSetDeliveryOptionsArgs>? = null,
    public val name: Output<String>? = null,
    public val reputationMetricsEnabled: Output<Boolean>? = null,
    public val sendingEnabled: Output<Boolean>? = null,
    public val trackingOptions: Output<ConfigurationSetTrackingOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ConfigurationSetArgs> {
    override fun toJava(): com.pulumi.aws.ses.ConfigurationSetArgs =
        com.pulumi.aws.ses.ConfigurationSetArgs.builder()
            .deliveryOptions(deliveryOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reputationMetricsEnabled(reputationMetricsEnabled?.applyValue({ args0 -> args0 }))
            .sendingEnabled(sendingEnabled?.applyValue({ args0 -> args0 }))
            .trackingOptions(
                trackingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationSetArgs].
 */
@PulumiTagMarker
public class ConfigurationSetArgsBuilder internal constructor() {
    private var deliveryOptions: Output<ConfigurationSetDeliveryOptionsArgs>? = null

    private var name: Output<String>? = null

    private var reputationMetricsEnabled: Output<Boolean>? = null

    private var sendingEnabled: Output<Boolean>? = null

    private var trackingOptions: Output<ConfigurationSetTrackingOptionsArgs>? = null

    /**
     * @param value Whether messages that use the configuration set are required to use TLS. See below.
     */
    @JvmName("myfsrchwtmokvtrr")
    public suspend fun deliveryOptions(`value`: Output<ConfigurationSetDeliveryOptionsArgs>) {
        this.deliveryOptions = value
    }

    /**
     * @param value Name of the configuration set.
     * The following argument is optional:
     */
    @JvmName("gackhilurqgfelfn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch. The default value is `false`.
     */
    @JvmName("uknjqedvwhbpkbjh")
    public suspend fun reputationMetricsEnabled(`value`: Output<Boolean>) {
        this.reputationMetricsEnabled = value
    }

    /**
     * @param value Whether email sending is enabled or disabled for the configuration set. The default value is `true`.
     */
    @JvmName("pluvlbihlitmithq")
    public suspend fun sendingEnabled(`value`: Output<Boolean>) {
        this.sendingEnabled = value
    }

    /**
     * @param value Domain that is used to redirect email recipients to an Amazon SES-operated domain. See below. **NOTE:** This functionality is best effort.
     */
    @JvmName("tdjvelpdrhsjjrdr")
    public suspend fun trackingOptions(`value`: Output<ConfigurationSetTrackingOptionsArgs>) {
        this.trackingOptions = value
    }

    /**
     * @param value Whether messages that use the configuration set are required to use TLS. See below.
     */
    @JvmName("bwfbtyrxhjqesljv")
    public suspend fun deliveryOptions(`value`: ConfigurationSetDeliveryOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryOptions = mapped
    }

    /**
     * @param argument Whether messages that use the configuration set are required to use TLS. See below.
     */
    @JvmName("ipoudbmpojtveiwd")
    public suspend fun deliveryOptions(argument: suspend ConfigurationSetDeliveryOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetDeliveryOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryOptions = mapped
    }

    /**
     * @param value Name of the configuration set.
     * The following argument is optional:
     */
    @JvmName("imakhmeufmpxvbmh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch. The default value is `false`.
     */
    @JvmName("imwimibtcdbsqbbj")
    public suspend fun reputationMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reputationMetricsEnabled = mapped
    }

    /**
     * @param value Whether email sending is enabled or disabled for the configuration set. The default value is `true`.
     */
    @JvmName("itxlggjofshoedjy")
    public suspend fun sendingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendingEnabled = mapped
    }

    /**
     * @param value Domain that is used to redirect email recipients to an Amazon SES-operated domain. See below. **NOTE:** This functionality is best effort.
     */
    @JvmName("iaarkexgtsthtbld")
    public suspend fun trackingOptions(`value`: ConfigurationSetTrackingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingOptions = mapped
    }

    /**
     * @param argument Domain that is used to redirect email recipients to an Amazon SES-operated domain. See below. **NOTE:** This functionality is best effort.
     */
    @JvmName("rnbgsyshawbvwxvp")
    public suspend fun trackingOptions(argument: suspend ConfigurationSetTrackingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetTrackingOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trackingOptions = mapped
    }

    internal fun build(): ConfigurationSetArgs = ConfigurationSetArgs(
        deliveryOptions = deliveryOptions,
        name = name,
        reputationMetricsEnabled = reputationMetricsEnabled,
        sendingEnabled = sendingEnabled,
        trackingOptions = trackingOptions,
    )
}
