@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainDkim].
 */
@PulumiTagMarker
public class DomainDkimResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainDkimArgs = DomainDkimArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainDkimArgsBuilder.() -> Unit) {
        val builder = DomainDkimArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainDkim {
        val builtJavaResource = com.pulumi.aws.ses.DomainDkim(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainDkim(builtJavaResource)
    }
}

/**
 * Provides an SES domain DKIM generation resource.
 * Domain ownership needs to be confirmed first using ses_domain_identity Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ses.DomainIdentity("example", {domain: "example.com"});
 * const exampleDomainDkim = new aws.ses.DomainDkim("example", {domain: example.domain});
 * const exampleAmazonsesDkimRecord: aws.route53.Record[] = [];
 * for (const range = {value: 0}; range.value < 3; range.value++) {
 *     exampleAmazonsesDkimRecord.push(new aws.route53.Record(`example_amazonses_dkim_record-${range.value}`, {
 *         zoneId: "ABCDEFGHIJ123",
 *         name: exampleDomainDkim.dkimTokens.apply(dkimTokens => `${dkimTokens[range&#46;value]}._domainkey`),
 *         type: aws.route53.RecordType.CNAME,
 *         ttl: 600,
 *         records: [exampleDomainDkim&#46;dkimTokens&#46;apply(dkimTokens => `${dkimTokens[range&#46;value]}&#46;dkim&#46;amazonses&#46;com`)],
 *     }));
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ses.DomainIdentity("example", domain="example.com")
 * example_domain_dkim = aws.ses.DomainDkim("example", domain=example.domain)
 * example_amazonses_dkim_record = []
 * for range in [{"value": i} for i in range(0, 3)]:
 *     example_amazonses_dkim_record.append(aws.route53.Record(f"example_amazonses_dkim_record-{range['value']}",
 *         zone_id="ABCDEFGHIJ123",
 *         name=example_domain_dkim.dkim_tokens.apply(lambda dkim_tokens: f"{dkim_tokens[range['value']]}._domainkey"),
 *         type=aws.route53.RecordType.CNAME,
 *         ttl=600,
 *         records=[example_domain_dkim&#46;dkim_tokens&#46;apply(lambda dkim_tokens: f"{dkim_tokens[range['value']]}&#46;dkim&#46;amazonses&#46;com")]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ses.DomainIdentity("example", new()
 *     {
 *         Domain = "example.com",
 *     });
 *     var exampleDomainDkim = new Aws.Ses.DomainDkim("example", new()
 *     {
 *         Domain = example.Domain,
 *     });
 *     var exampleAmazonsesDkimRecord = new List<Aws.Route53.Record>();
 *     for (var rangeIndex = 0; rangeIndex < 3; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         exampleAmazonsesDkimRecord.Add(new Aws.Route53.Record($"example_amazonses_dkim_record-{range.Value}", new()
 *         {
 *             ZoneId = "ABCDEFGHIJ123",
 *             Name = exampleDomainDkim.DkimTokens.Apply(dkimTokens => $"{dkimTokens[range&#46;Value]}._domainkey"),
 *             Type = Aws.Route53.RecordType.CNAME,
 *             Ttl = 600,
 *             Records = new[]
 *             {
 *                 exampleDomainDkim.DkimTokens.Apply(dkimTokens => $"{dkimTokens[range&#46;Value]}.dkim.amazonses.com"),
 *             },
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ses.NewDomainIdentity(ctx, "example", &ses.DomainIdentityArgs{
 * 			Domain: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDomainDkim, err := ses.NewDomainDkim(ctx, "example", &ses.DomainDkimArgs{
 * 			Domain: example.Domain,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var exampleAmazonsesDkimRecord []*route53.Record
 * 		for index := 0; index < 3; index++ {
 * 			key0 := index
 * 			val0 := index
 * 			__res, err := route53.NewRecord(ctx, fmt.Sprintf("example_amazonses_dkim_record-%v", key0), &route53.RecordArgs{
 * 				ZoneId: pulumi.String("ABCDEFGHIJ123"),
 * 				Name: exampleDomainDkim.DkimTokens.ApplyT(func(dkimTokens []string) (string, error) {
 * 					return fmt.Sprintf("%v._domainkey", dkimTokens[val0]), nil
 * 				}).(pulumi.StringOutput),
 * 				Type: pulumi.String(route53.RecordTypeCNAME),
 * 				Ttl:  pulumi.Int(600),
 * 				Records: pulumi.StringArray{
 * 					exampleDomainDkim.DkimTokens.ApplyT(func(dkimTokens []string) (string, error) {
 * 						return fmt.Sprintf("%v.dkim.amazonses.com", dkimTokens[val0]), nil
 * 					}).(pulumi.StringOutput),
 * 				},
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			exampleAmazonsesDkimRecord = append(exampleAmazonsesDkimRecord, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.ses.DomainDkim;
 * import com.pulumi.aws.ses.DomainDkimArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleDomainDkim = new DomainDkim("exampleDomainDkim", DomainDkimArgs.builder()
 *             .domain(example.domain())
 *             .build());
 *         for (var i = 0; i < 3; i++) {
 *             new Record("exampleAmazonsesDkimRecord-" + i, RecordArgs.builder()
 *                 .zoneId("ABCDEFGHIJ123")
 *                 .name(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s._domainkey", dkimTokens[range&#46;value()])))
 *                 .type("CNAME")
 *                 .ttl("600")
 *                 .records(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s.dkim.amazonses.com", dkimTokens[range&#46;value()])))
 *                 .build());
 * }
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DKIM tokens using the `domain` attribute. For example:
 * ```sh
 * $ pulumi import aws:ses/domainDkim:DomainDkim example example.com
 * ```
 */
public class DomainDkim internal constructor(
    override val javaResource: com.pulumi.aws.ses.DomainDkim,
) : KotlinCustomResource(javaResource, DomainDkimMapper) {
    /**
     * DKIM tokens generated by SES.
     * These tokens should be used to create CNAME records used to verify SES Easy DKIM.
     * See below for an example of how this might be achieved
     * when the domain is hosted in Route 53 and managed by this provider.
     * Find out more about verifying domains in Amazon SES
     * in the [AWS SES docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
     */
    public val dkimTokens: Output<List<String>>
        get() = javaResource.dkimTokens().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Verified domain name to generate DKIM tokens for.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })
}

public object DomainDkimMapper : ResourceMapper<DomainDkim> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.DomainDkim::class == javaResource::class

    override fun map(javaResource: Resource): DomainDkim = DomainDkim(
        javaResource as
            com.pulumi.aws.ses.DomainDkim,
    )
}

/**
 * @see [DomainDkim].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainDkim].
 */
public suspend fun domainDkim(name: String, block: suspend DomainDkimResourceBuilder.() -> Unit): DomainDkim {
    val builder = DomainDkimResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainDkim].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainDkim(name: String): DomainDkim {
    val builder = DomainDkimResourceBuilder()
    builder.name(name)
    return builder.build()
}
