@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IdentityPolicy].
 */
@PulumiTagMarker
public class IdentityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityPolicyArgs = IdentityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityPolicyArgsBuilder.() -> Unit) {
        val builder = IdentityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IdentityPolicy {
        val builtJavaResource = com.pulumi.aws.ses.IdentityPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IdentityPolicy(builtJavaResource)
    }
}

/**
 * Manages a SES Identity Policy. More information about SES Sending Authorization Policies can be found in the [SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleDomainIdentity = new aws.ses.DomainIdentity("example", {domain: "example.com"});
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         actions: [
 *             "SES:SendEmail",
 *             "SES:SendRawEmail",
 *         ],
 *         resources: [exampleDomainIdentity&#46;arn],
 *         principals: [{
 *             identifiers: ["*"],
 *             type: "AWS",
 *         }],
 *     }],
 * });
 * const exampleIdentityPolicy = new aws.ses.IdentityPolicy("example", {
 *     identity: exampleDomainIdentity.arn,
 *     name: "example",
 *     policy: example.apply(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_domain_identity = aws.ses.DomainIdentity("example", domain="example.com")
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "actions": [
 *         "SES:SendEmail",
 *         "SES:SendRawEmail",
 *     ],
 *     "resources": [example_domain_identity&#46;arn],
 *     "principals": [{
 *         "identifiers": ["*"],
 *         "type": "AWS",
 *     }],
 * }])
 * example_identity_policy = aws.ses.IdentityPolicy("example",
 *     identity=example_domain_identity.arn,
 *     name="example",
 *     policy=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleDomainIdentity = new Aws.Ses.DomainIdentity("example", new()
 *     {
 *         Domain = "example.com",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "SES:SendEmail",
 *                     "SES:SendRawEmail",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleDomainIdentity.Arn,
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                         Type = "AWS",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleIdentityPolicy = new Aws.Ses.IdentityPolicy("example", new()
 *     {
 *         Identity = exampleDomainIdentity.Arn,
 *         Name = "example",
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleDomainIdentity, err := ses.NewDomainIdentity(ctx, "example", &ses.DomainIdentityArgs{
 * 			Domain: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("SES:SendEmail"),
 * 						pulumi.String("SES:SendRawEmail"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleDomainIdentity.Arn,
 * 					},
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							Type: pulumi.String("AWS"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = ses.NewIdentityPolicy(ctx, "example", &ses.IdentityPolicyArgs{
 * 			Identity: exampleDomainIdentity.Arn,
 * 			Name:     pulumi.String("example"),
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ses.IdentityPolicy;
 * import com.pulumi.aws.ses.IdentityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "SES:SendEmail",
 *                     "SES:SendRawEmail")
 *                 .resources(exampleDomainIdentity.arn())
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("*")
 *                     .type("AWS")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleIdentityPolicy = new IdentityPolicy("exampleIdentityPolicy", IdentityPolicyArgs.builder()
 *             .identity(exampleDomainIdentity.arn())
 *             .name("example")
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDomainIdentity:
 *     type: aws:ses:DomainIdentity
 *     name: example
 *     properties:
 *       domain: example.com
 *   exampleIdentityPolicy:
 *     type: aws:ses:IdentityPolicy
 *     name: example
 *     properties:
 *       identity: ${exampleDomainIdentity.arn}
 *       name: example
 *       policy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - SES:SendEmail
 *               - SES:SendRawEmail
 *             resources:
 *               - ${exampleDomainIdentity.arn}
 *             principals:
 *               - identifiers:
 *                   - '*'
 *                 type: AWS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES Identity Policies using the identity and policy name, separated by a pipe character (`|`). For example:
 * ```sh
 * $ pulumi import aws:ses/identityPolicy:IdentityPolicy example 'example.com|example'
 * ```
 */
public class IdentityPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ses.IdentityPolicy,
) : KotlinCustomResource(javaResource, IdentityPolicyMapper) {
    /**
     * Name or Amazon Resource Name (ARN) of the SES Identity.
     */
    public val identity: Output<String>
        get() = javaResource.identity().applyValue({ args0 -> args0 })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * JSON string of the policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object IdentityPolicyMapper : ResourceMapper<IdentityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.IdentityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): IdentityPolicy = IdentityPolicy(
        javaResource as
            com.pulumi.aws.ses.IdentityPolicy,
    )
}

/**
 * @see [IdentityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityPolicy].
 */
public suspend fun identityPolicy(
    name: String,
    block: suspend IdentityPolicyResourceBuilder.() -> Unit,
): IdentityPolicy {
    val builder = IdentityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityPolicy(name: String): IdentityPolicy {
    val builder = IdentityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
