@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt filter resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const filter = new aws.ses.ReceiptFilter("filter", {
 *     name: "block-spammer",
 *     cidr: "10.10.10.10",
 *     policy: "Block",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * filter = aws.ses.ReceiptFilter("filter",
 *     name="block-spammer",
 *     cidr="10.10.10.10",
 *     policy="Block")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var filter = new Aws.Ses.ReceiptFilter("filter", new()
 *     {
 *         Name = "block-spammer",
 *         Cidr = "10.10.10.10",
 *         Policy = "Block",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewReceiptFilter(ctx, "filter", &ses.ReceiptFilterArgs{
 * 			Name:   pulumi.String("block-spammer"),
 * 			Cidr:   pulumi.String("10.10.10.10"),
 * 			Policy: pulumi.String("Block"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptFilter;
 * import com.pulumi.aws.ses.ReceiptFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new ReceiptFilter("filter", ReceiptFilterArgs.builder()
 *             .name("block-spammer")
 *             .cidr("10.10.10.10")
 *             .policy("Block")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   filter:
 *     type: aws:ses:ReceiptFilter
 *     properties:
 *       name: block-spammer
 *       cidr: 10.10.10.10
 *       policy: Block
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES Receipt Filter using their `name`. For example:
 * ```sh
 * $ pulumi import aws:ses/receiptFilter:ReceiptFilter test some-filter
 * ```
 * @property cidr The IP address or address range to filter, in CIDR notation
 * @property name The name of the filter
 * @property policy Block or Allow
 */
public data class ReceiptFilterArgs(
    public val cidr: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptFilterArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptFilterArgs =
        com.pulumi.aws.ses.ReceiptFilterArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptFilterArgs].
 */
@PulumiTagMarker
public class ReceiptFilterArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The IP address or address range to filter, in CIDR notation
     */
    @JvmName("sjufrxyegdhqahmy")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The name of the filter
     */
    @JvmName("ahhaquomjskebcfp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Block or Allow
     */
    @JvmName("vmvnpakdpqhednrp")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The IP address or address range to filter, in CIDR notation
     */
    @JvmName("kgpanhpcunraulce")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The name of the filter
     */
    @JvmName("hagsdsbkvkrdiwkm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Block or Allow
     */
    @JvmName("bsyvmmrfruamxnld")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ReceiptFilterArgs = ReceiptFilterArgs(
        cidr = cidr,
        name = name,
        policy = policy,
    )
}
