@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptRuleArgs.builder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleAddHeaderActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleAddHeaderActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleBounceActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleBounceActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleLambdaActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleLambdaActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleS3ActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleS3ActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleSnsActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleSnsActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleStopActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleStopActionArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleWorkmailActionArgs
import com.pulumi.aws.ses.kotlin.inputs.ReceiptRuleWorkmailActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt rule resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Add a header to the email and store it in S3
 * const store = new aws.ses.ReceiptRule("store", {
 *     name: "store",
 *     ruleSetName: "default-rule-set",
 *     recipients: ["karen@example&#46;com"],
 *     enabled: true,
 *     scanEnabled: true,
 *     addHeaderActions: [{
 *         headerName: "Custom-Header",
 *         headerValue: "Added by SES",
 *         position: 1,
 *     }],
 *     s3Actions: [{
 *         bucketName: "emails",
 *         position: 2,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Add a header to the email and store it in S3
 * store = aws.ses.ReceiptRule("store",
 *     name="store",
 *     rule_set_name="default-rule-set",
 *     recipients=["karen@example&#46;com"],
 *     enabled=True,
 *     scan_enabled=True,
 *     add_header_actions=[{
 *         "header_name": "Custom-Header",
 *         "header_value": "Added by SES",
 *         "position": 1,
 *     }],
 *     s3_actions=[{
 *         "bucket_name": "emails",
 *         "position": 2,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a header to the email and store it in S3
 *     var store = new Aws.Ses.ReceiptRule("store", new()
 *     {
 *         Name = "store",
 *         RuleSetName = "default-rule-set",
 *         Recipients = new[]
 *         {
 *             "karen@example.com",
 *         },
 *         Enabled = true,
 *         ScanEnabled = true,
 *         AddHeaderActions = new[]
 *         {
 *             new Aws.Ses.Inputs.ReceiptRuleAddHeaderActionArgs
 *             {
 *                 HeaderName = "Custom-Header",
 *                 HeaderValue = "Added by SES",
 *                 Position = 1,
 *             },
 *         },
 *         S3Actions = new[]
 *         {
 *             new Aws.Ses.Inputs.ReceiptRuleS3ActionArgs
 *             {
 *                 BucketName = "emails",
 *                 Position = 2,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a header to the email and store it in S3
 * 		_, err := ses.NewReceiptRule(ctx, "store", &ses.ReceiptRuleArgs{
 * 			Name:        pulumi.String("store"),
 * 			RuleSetName: pulumi.String("default-rule-set"),
 * 			Recipients: pulumi.StringArray{
 * 				pulumi.String("karen@example.com"),
 * 			},
 * 			Enabled:     pulumi.Bool(true),
 * 			ScanEnabled: pulumi.Bool(true),
 * 			AddHeaderActions: ses.ReceiptRuleAddHeaderActionArray{
 * 				&ses.ReceiptRuleAddHeaderActionArgs{
 * 					HeaderName:  pulumi.String("Custom-Header"),
 * 					HeaderValue: pulumi.String("Added by SES"),
 * 					Position:    pulumi.Int(1),
 * 				},
 * 			},
 * 			S3Actions: ses.ReceiptRuleS3ActionArray{
 * 				&ses.ReceiptRuleS3ActionArgs{
 * 					BucketName: pulumi.String("emails"),
 * 					Position:   pulumi.Int(2),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRule;
 * import com.pulumi.aws.ses.ReceiptRuleArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleAddHeaderActionArgs;
 * import com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a header to the email and store it in S3
 *         var store = new ReceiptRule("store", ReceiptRuleArgs.builder()
 *             .name("store")
 *             .ruleSetName("default-rule-set")
 *             .recipients("karen@example.com")
 *             .enabled(true)
 *             .scanEnabled(true)
 *             .addHeaderActions(ReceiptRuleAddHeaderActionArgs.builder()
 *                 .headerName("Custom-Header")
 *                 .headerValue("Added by SES")
 *                 .position(1)
 *                 .build())
 *             .s3Actions(ReceiptRuleS3ActionArgs.builder()
 *                 .bucketName("emails")
 *                 .position(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a header to the email and store it in S3
 *   store:
 *     type: aws:ses:ReceiptRule
 *     properties:
 *       name: store
 *       ruleSetName: default-rule-set
 *       recipients:
 *         - karen@example.com
 *       enabled: true
 *       scanEnabled: true
 *       addHeaderActions:
 *         - headerName: Custom-Header
 *           headerValue: Added by SES
 *           position: 1
 *       s3Actions:
 *         - bucketName: emails
 *           position: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES receipt rules using the ruleset name and rule name separated by `:`. For example:
 * ```sh
 * $ pulumi import aws:ses/receiptRule:ReceiptRule my_rule my_rule_set:my_rule
 * ```
 * @property addHeaderActions A list of Add Header Action blocks. Documented below.
 * @property after The name of the rule to place this rule after
 * @property bounceActions A list of Bounce Action blocks. Documented below.
 * @property enabled If true, the rule will be enabled
 * @property lambdaActions A list of Lambda Action blocks. Documented below.
 * @property name The name of the rule
 * @property recipients A list of email addresses
 * @property ruleSetName The name of the rule set
 * @property s3Actions A list of S3 Action blocks. Documented below.
 * @property scanEnabled If true, incoming emails will be scanned for spam and viruses
 * @property snsActions A list of SNS Action blocks. Documented below.
 * @property stopActions A list of Stop Action blocks. Documented below.
 * @property tlsPolicy `Require` or `Optional`
 * @property workmailActions A list of WorkMail Action blocks. Documented below.
 */
public data class ReceiptRuleArgs(
    public val addHeaderActions: Output<List<ReceiptRuleAddHeaderActionArgs>>? = null,
    public val after: Output<String>? = null,
    public val bounceActions: Output<List<ReceiptRuleBounceActionArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val lambdaActions: Output<List<ReceiptRuleLambdaActionArgs>>? = null,
    public val name: Output<String>? = null,
    public val recipients: Output<List<String>>? = null,
    public val ruleSetName: Output<String>? = null,
    public val s3Actions: Output<List<ReceiptRuleS3ActionArgs>>? = null,
    public val scanEnabled: Output<Boolean>? = null,
    public val snsActions: Output<List<ReceiptRuleSnsActionArgs>>? = null,
    public val stopActions: Output<List<ReceiptRuleStopActionArgs>>? = null,
    public val tlsPolicy: Output<String>? = null,
    public val workmailActions: Output<List<ReceiptRuleWorkmailActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptRuleArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptRuleArgs =
        com.pulumi.aws.ses.ReceiptRuleArgs.builder()
            .addHeaderActions(
                addHeaderActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .after(after?.applyValue({ args0 -> args0 }))
            .bounceActions(
                bounceActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lambdaActions(
                lambdaActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .recipients(recipients?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 }))
            .s3Actions(
                s3Actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scanEnabled(scanEnabled?.applyValue({ args0 -> args0 }))
            .snsActions(
                snsActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stopActions(
                stopActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tlsPolicy(tlsPolicy?.applyValue({ args0 -> args0 }))
            .workmailActions(
                workmailActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReceiptRuleArgs].
 */
@PulumiTagMarker
public class ReceiptRuleArgsBuilder internal constructor() {
    private var addHeaderActions: Output<List<ReceiptRuleAddHeaderActionArgs>>? = null

    private var after: Output<String>? = null

    private var bounceActions: Output<List<ReceiptRuleBounceActionArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var lambdaActions: Output<List<ReceiptRuleLambdaActionArgs>>? = null

    private var name: Output<String>? = null

    private var recipients: Output<List<String>>? = null

    private var ruleSetName: Output<String>? = null

    private var s3Actions: Output<List<ReceiptRuleS3ActionArgs>>? = null

    private var scanEnabled: Output<Boolean>? = null

    private var snsActions: Output<List<ReceiptRuleSnsActionArgs>>? = null

    private var stopActions: Output<List<ReceiptRuleStopActionArgs>>? = null

    private var tlsPolicy: Output<String>? = null

    private var workmailActions: Output<List<ReceiptRuleWorkmailActionArgs>>? = null

    /**
     * @param value A list of Add Header Action blocks. Documented below.
     */
    @JvmName("lhhuktnefosvmvib")
    public suspend fun addHeaderActions(`value`: Output<List<ReceiptRuleAddHeaderActionArgs>>) {
        this.addHeaderActions = value
    }

    @JvmName("yahyurpkcenhmsky")
    public suspend fun addHeaderActions(vararg values: Output<ReceiptRuleAddHeaderActionArgs>) {
        this.addHeaderActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Add Header Action blocks. Documented below.
     */
    @JvmName("lsfyphhefklvidiw")
    public suspend fun addHeaderActions(values: List<Output<ReceiptRuleAddHeaderActionArgs>>) {
        this.addHeaderActions = Output.all(values)
    }

    /**
     * @param value The name of the rule to place this rule after
     */
    @JvmName("jmtnrssfwtkcsgbg")
    public suspend fun after(`value`: Output<String>) {
        this.after = value
    }

    /**
     * @param value A list of Bounce Action blocks. Documented below.
     */
    @JvmName("oykycxhaeyrkebgl")
    public suspend fun bounceActions(`value`: Output<List<ReceiptRuleBounceActionArgs>>) {
        this.bounceActions = value
    }

    @JvmName("jckkcfedfxdaogur")
    public suspend fun bounceActions(vararg values: Output<ReceiptRuleBounceActionArgs>) {
        this.bounceActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Bounce Action blocks. Documented below.
     */
    @JvmName("ihksfhvcqanmagnv")
    public suspend fun bounceActions(values: List<Output<ReceiptRuleBounceActionArgs>>) {
        this.bounceActions = Output.all(values)
    }

    /**
     * @param value If true, the rule will be enabled
     */
    @JvmName("utcrbmyjnxbhmtsm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of Lambda Action blocks. Documented below.
     */
    @JvmName("ovkxnwspfisasgel")
    public suspend fun lambdaActions(`value`: Output<List<ReceiptRuleLambdaActionArgs>>) {
        this.lambdaActions = value
    }

    @JvmName("cdirpyvqlrnwrliq")
    public suspend fun lambdaActions(vararg values: Output<ReceiptRuleLambdaActionArgs>) {
        this.lambdaActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Lambda Action blocks. Documented below.
     */
    @JvmName("fdlklmjjgaelrlhn")
    public suspend fun lambdaActions(values: List<Output<ReceiptRuleLambdaActionArgs>>) {
        this.lambdaActions = Output.all(values)
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("hwrbyblsjmviyhse")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of email addresses
     */
    @JvmName("fwndwgtmawcblruq")
    public suspend fun recipients(`value`: Output<List<String>>) {
        this.recipients = value
    }

    @JvmName("gwsuosrtkuqaaafi")
    public suspend fun recipients(vararg values: Output<String>) {
        this.recipients = Output.all(values.asList())
    }

    /**
     * @param values A list of email addresses
     */
    @JvmName("hhgqlqwobimcuayd")
    public suspend fun recipients(values: List<Output<String>>) {
        this.recipients = Output.all(values)
    }

    /**
     * @param value The name of the rule set
     */
    @JvmName("qjglaxlwfccqhkuo")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value A list of S3 Action blocks. Documented below.
     */
    @JvmName("udbuloqdelicwwox")
    public suspend fun s3Actions(`value`: Output<List<ReceiptRuleS3ActionArgs>>) {
        this.s3Actions = value
    }

    @JvmName("rrtaksbkrqsflqou")
    public suspend fun s3Actions(vararg values: Output<ReceiptRuleS3ActionArgs>) {
        this.s3Actions = Output.all(values.asList())
    }

    /**
     * @param values A list of S3 Action blocks. Documented below.
     */
    @JvmName("jeoupthjrtgrmeyh")
    public suspend fun s3Actions(values: List<Output<ReceiptRuleS3ActionArgs>>) {
        this.s3Actions = Output.all(values)
    }

    /**
     * @param value If true, incoming emails will be scanned for spam and viruses
     */
    @JvmName("kyviohspnwtvjhnj")
    public suspend fun scanEnabled(`value`: Output<Boolean>) {
        this.scanEnabled = value
    }

    /**
     * @param value A list of SNS Action blocks. Documented below.
     */
    @JvmName("tvelfljumwrnsjls")
    public suspend fun snsActions(`value`: Output<List<ReceiptRuleSnsActionArgs>>) {
        this.snsActions = value
    }

    @JvmName("rtolsevmirvkbpog")
    public suspend fun snsActions(vararg values: Output<ReceiptRuleSnsActionArgs>) {
        this.snsActions = Output.all(values.asList())
    }

    /**
     * @param values A list of SNS Action blocks. Documented below.
     */
    @JvmName("bjasoqcmhrapaako")
    public suspend fun snsActions(values: List<Output<ReceiptRuleSnsActionArgs>>) {
        this.snsActions = Output.all(values)
    }

    /**
     * @param value A list of Stop Action blocks. Documented below.
     */
    @JvmName("jjdcffkufupryggg")
    public suspend fun stopActions(`value`: Output<List<ReceiptRuleStopActionArgs>>) {
        this.stopActions = value
    }

    @JvmName("jtqbfwxvlacclhuu")
    public suspend fun stopActions(vararg values: Output<ReceiptRuleStopActionArgs>) {
        this.stopActions = Output.all(values.asList())
    }

    /**
     * @param values A list of Stop Action blocks. Documented below.
     */
    @JvmName("prfwyqogbhrvigrv")
    public suspend fun stopActions(values: List<Output<ReceiptRuleStopActionArgs>>) {
        this.stopActions = Output.all(values)
    }

    /**
     * @param value `Require` or `Optional`
     */
    @JvmName("yagxoblsaopjsmfv")
    public suspend fun tlsPolicy(`value`: Output<String>) {
        this.tlsPolicy = value
    }

    /**
     * @param value A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("snyhedqtpcxyhlbb")
    public suspend fun workmailActions(`value`: Output<List<ReceiptRuleWorkmailActionArgs>>) {
        this.workmailActions = value
    }

    @JvmName("wtnqrhgwnyvhrjlc")
    public suspend fun workmailActions(vararg values: Output<ReceiptRuleWorkmailActionArgs>) {
        this.workmailActions = Output.all(values.asList())
    }

    /**
     * @param values A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("svxfesesnlqjjfbs")
    public suspend fun workmailActions(values: List<Output<ReceiptRuleWorkmailActionArgs>>) {
        this.workmailActions = Output.all(values)
    }

    /**
     * @param value A list of Add Header Action blocks. Documented below.
     */
    @JvmName("schhutktcphrrdnm")
    public suspend fun addHeaderActions(`value`: List<ReceiptRuleAddHeaderActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("cknydkwdyctkdddx")
    public suspend fun addHeaderActions(argument: List<suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("wxexxjpalhobhvhb")
    public suspend fun addHeaderActions(vararg argument: suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param argument A list of Add Header Action blocks. Documented below.
     */
    @JvmName("lomipwaxiioslxsd")
    public suspend fun addHeaderActions(argument: suspend ReceiptRuleAddHeaderActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleAddHeaderActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.addHeaderActions = mapped
    }

    /**
     * @param values A list of Add Header Action blocks. Documented below.
     */
    @JvmName("jinicxhwunmyakfr")
    public suspend fun addHeaderActions(vararg values: ReceiptRuleAddHeaderActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addHeaderActions = mapped
    }

    /**
     * @param value The name of the rule to place this rule after
     */
    @JvmName("kjmuudrmaiewooty")
    public suspend fun after(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.after = mapped
    }

    /**
     * @param value A list of Bounce Action blocks. Documented below.
     */
    @JvmName("xhyycojwdnlghoir")
    public suspend fun bounceActions(`value`: List<ReceiptRuleBounceActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("ywynwbsrydysbxml")
    public suspend fun bounceActions(argument: List<suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("kkaeujgcxwjfwdoa")
    public suspend fun bounceActions(vararg argument: suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param argument A list of Bounce Action blocks. Documented below.
     */
    @JvmName("itdhwaiwboseibqq")
    public suspend fun bounceActions(argument: suspend ReceiptRuleBounceActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleBounceActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bounceActions = mapped
    }

    /**
     * @param values A list of Bounce Action blocks. Documented below.
     */
    @JvmName("yhduksecmftefiit")
    public suspend fun bounceActions(vararg values: ReceiptRuleBounceActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bounceActions = mapped
    }

    /**
     * @param value If true, the rule will be enabled
     */
    @JvmName("grqrwbtghgeecdms")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of Lambda Action blocks. Documented below.
     */
    @JvmName("dpuoklrfhfnpicah")
    public suspend fun lambdaActions(`value`: List<ReceiptRuleLambdaActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("sytwwhdirvpaxenn")
    public suspend fun lambdaActions(argument: List<suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("jondvsjrkiqhgyoa")
    public suspend fun lambdaActions(vararg argument: suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param argument A list of Lambda Action blocks. Documented below.
     */
    @JvmName("dkrxavnswcvtucpg")
    public suspend fun lambdaActions(argument: suspend ReceiptRuleLambdaActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleLambdaActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lambdaActions = mapped
    }

    /**
     * @param values A list of Lambda Action blocks. Documented below.
     */
    @JvmName("iyypmpvqicidunbk")
    public suspend fun lambdaActions(vararg values: ReceiptRuleLambdaActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaActions = mapped
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("vrcujvuoubeyvaxg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of email addresses
     */
    @JvmName("jdshwaqoriebmigm")
    public suspend fun recipients(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param values A list of email addresses
     */
    @JvmName("dmaufkmxmmddsvtu")
    public suspend fun recipients(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param value The name of the rule set
     */
    @JvmName("ohuptlfummsuwwod")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    /**
     * @param value A list of S3 Action blocks. Documented below.
     */
    @JvmName("kvtvgcamjgfmahhq")
    public suspend fun s3Actions(`value`: List<ReceiptRuleS3ActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("cmbpklomfdisnsvh")
    public suspend fun s3Actions(argument: List<suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleS3ActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("wwmsgglcumbxeehk")
    public suspend fun s3Actions(vararg argument: suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleS3ActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param argument A list of S3 Action blocks. Documented below.
     */
    @JvmName("drenwliunpnsqvvt")
    public suspend fun s3Actions(argument: suspend ReceiptRuleS3ActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleS3ActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3Actions = mapped
    }

    /**
     * @param values A list of S3 Action blocks. Documented below.
     */
    @JvmName("jkboynwqwfinxjjs")
    public suspend fun s3Actions(vararg values: ReceiptRuleS3ActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Actions = mapped
    }

    /**
     * @param value If true, incoming emails will be scanned for spam and viruses
     */
    @JvmName("jwnlqvhhvnndmnpv")
    public suspend fun scanEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanEnabled = mapped
    }

    /**
     * @param value A list of SNS Action blocks. Documented below.
     */
    @JvmName("sfyglqcoendnufjw")
    public suspend fun snsActions(`value`: List<ReceiptRuleSnsActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("fteniodmhsmcyvgl")
    public suspend fun snsActions(argument: List<suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleSnsActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("emxygdqvtnkjnlig")
    public suspend fun snsActions(vararg argument: suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleSnsActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param argument A list of SNS Action blocks. Documented below.
     */
    @JvmName("wgwlbwqiqwopqvfc")
    public suspend fun snsActions(argument: suspend ReceiptRuleSnsActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleSnsActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.snsActions = mapped
    }

    /**
     * @param values A list of SNS Action blocks. Documented below.
     */
    @JvmName("tfbpfguoqxvaxpdk")
    public suspend fun snsActions(vararg values: ReceiptRuleSnsActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsActions = mapped
    }

    /**
     * @param value A list of Stop Action blocks. Documented below.
     */
    @JvmName("lpafpvqkkqxghuvm")
    public suspend fun stopActions(`value`: List<ReceiptRuleStopActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("cepldxxsqfggtgld")
    public suspend fun stopActions(argument: List<suspend ReceiptRuleStopActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleStopActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("icxnsmpqojsejcjk")
    public suspend fun stopActions(vararg argument: suspend ReceiptRuleStopActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleStopActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param argument A list of Stop Action blocks. Documented below.
     */
    @JvmName("uificyrnvkhgscsm")
    public suspend fun stopActions(argument: suspend ReceiptRuleStopActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReceiptRuleStopActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stopActions = mapped
    }

    /**
     * @param values A list of Stop Action blocks. Documented below.
     */
    @JvmName("bujuuabnuekkoscl")
    public suspend fun stopActions(vararg values: ReceiptRuleStopActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopActions = mapped
    }

    /**
     * @param value `Require` or `Optional`
     */
    @JvmName("hsyimcryabxwhymm")
    public suspend fun tlsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsPolicy = mapped
    }

    /**
     * @param value A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("bfvoxquifwsbujua")
    public suspend fun workmailActions(`value`: List<ReceiptRuleWorkmailActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("esgqahuawrtnrjel")
    public suspend fun workmailActions(argument: List<suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("eplahptffueosmpl")
    public suspend fun workmailActions(vararg argument: suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param argument A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("fdyaqrjdythyrfep")
    public suspend fun workmailActions(argument: suspend ReceiptRuleWorkmailActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ReceiptRuleWorkmailActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workmailActions = mapped
    }

    /**
     * @param values A list of WorkMail Action blocks. Documented below.
     */
    @JvmName("kntuocwakubpfgru")
    public suspend fun workmailActions(vararg values: ReceiptRuleWorkmailActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workmailActions = mapped
    }

    internal fun build(): ReceiptRuleArgs = ReceiptRuleArgs(
        addHeaderActions = addHeaderActions,
        after = after,
        bounceActions = bounceActions,
        enabled = enabled,
        lambdaActions = lambdaActions,
        name = name,
        recipients = recipients,
        ruleSetName = ruleSetName,
        s3Actions = s3Actions,
        scanEnabled = scanEnabled,
        snsActions = snsActions,
        stopActions = stopActions,
        tlsPolicy = tlsPolicy,
        workmailActions = workmailActions,
    )
}
