@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ReceiptRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES receipt rule set resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ses.ReceiptRuleSet("main", {ruleSetName: "primary-rules"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ses.ReceiptRuleSet("main", rule_set_name="primary-rules")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ses.ReceiptRuleSet("main", new()
 *     {
 *         RuleSetName = "primary-rules",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewReceiptRuleSet(ctx, "main", &ses.ReceiptRuleSetArgs{
 * 			RuleSetName: pulumi.String("primary-rules"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ReceiptRuleSet;
 * import com.pulumi.aws.ses.ReceiptRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new ReceiptRuleSet("main", ReceiptRuleSetArgs.builder()
 *             .ruleSetName("primary-rules")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ses:ReceiptRuleSet
 *     properties:
 *       ruleSetName: primary-rules
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES receipt rule sets using the rule set name. For example:
 * ```sh
 * $ pulumi import aws:ses/receiptRuleSet:ReceiptRuleSet my_rule_set my_rule_set_name
 * ```
 * @property ruleSetName Name of the rule set.
 */
public data class ReceiptRuleSetArgs(
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ReceiptRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.ses.ReceiptRuleSetArgs =
        com.pulumi.aws.ses.ReceiptRuleSetArgs.builder()
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleSetArgs].
 */
@PulumiTagMarker
public class ReceiptRuleSetArgsBuilder internal constructor() {
    private var ruleSetName: Output<String>? = null

    /**
     * @param value Name of the rule set.
     */
    @JvmName("sdeliypjvifnvuho")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Name of the rule set.
     */
    @JvmName("mncnpqosikkgnycg")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): ReceiptRuleSetArgs = ReceiptRuleSetArgs(
        ruleSetName = ruleSetName,
    )
}
