@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.SesFunctions.getActiveReceiptRuleSetPlain
import com.pulumi.aws.ses.SesFunctions.getDomainIdentityPlain
import com.pulumi.aws.ses.SesFunctions.getEmailIdentityPlain
import com.pulumi.aws.ses.kotlin.inputs.GetDomainIdentityPlainArgs
import com.pulumi.aws.ses.kotlin.inputs.GetDomainIdentityPlainArgsBuilder
import com.pulumi.aws.ses.kotlin.inputs.GetEmailIdentityPlainArgs
import com.pulumi.aws.ses.kotlin.inputs.GetEmailIdentityPlainArgsBuilder
import com.pulumi.aws.ses.kotlin.outputs.GetActiveReceiptRuleSetResult
import com.pulumi.aws.ses.kotlin.outputs.GetDomainIdentityResult
import com.pulumi.aws.ses.kotlin.outputs.GetEmailIdentityResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.ses.kotlin.outputs.GetActiveReceiptRuleSetResult.Companion.toKotlin as getActiveReceiptRuleSetResultToKotlin
import com.pulumi.aws.ses.kotlin.outputs.GetDomainIdentityResult.Companion.toKotlin as getDomainIdentityResultToKotlin
import com.pulumi.aws.ses.kotlin.outputs.GetEmailIdentityResult.Companion.toKotlin as getEmailIdentityResultToKotlin

public object SesFunctions {
    /**
     * Retrieve the active SES receipt rule set
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.ses.getActiveReceiptRuleSet({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.ses.get_active_receipt_rule_set()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.Ses.GetActiveReceiptRuleSet.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ses.LookupActiveReceiptRuleSet(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ses.SesFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = SesFunctions.getActiveReceiptRuleSet();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:ses:getActiveReceiptRuleSet
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Retrieve the active SES receipt rule set
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.ses.getActiveReceiptRuleSet({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.ses.get_active_receipt_rule_set()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.Ses.GetActiveReceiptRuleSet.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ses.LookupActiveReceiptRuleSet(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ses.SesFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = SesFunctions.getActiveReceiptRuleSet();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:ses:getActiveReceiptRuleSet
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getActiveReceiptRuleSet.
     */
    public suspend fun getActiveReceiptRuleSet(): GetActiveReceiptRuleSetResult =
        getActiveReceiptRuleSetResultToKotlin(getActiveReceiptRuleSetPlain().await())

    /**
     * Retrieve the SES domain identity
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ses.getDomainIdentity({
     *     domain: "example.com",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ses.get_domain_identity(domain="example.com")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ses.GetDomainIdentity.Invoke(new()
     *     {
     *         Domain = "example.com",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ses.LookupDomainIdentity(ctx, &ses.LookupDomainIdentityArgs{
     * 			Domain: "example.com",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ses.SesFunctions;
     * import com.pulumi.aws.ses.inputs.GetDomainIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SesFunctions.getDomainIdentity(GetDomainIdentityArgs.builder()
     *             .domain("example.com")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ses:getDomainIdentity
     *       Arguments:
     *         domain: example.com
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomainIdentity.
     * @return A collection of values returned by getDomainIdentity.
     */
    public suspend fun getDomainIdentity(argument: GetDomainIdentityPlainArgs): GetDomainIdentityResult =
        getDomainIdentityResultToKotlin(getDomainIdentityPlain(argument.toJava()).await())

    /**
     * @see [getDomainIdentity].
     * @param domain Name of the domain
     * @return A collection of values returned by getDomainIdentity.
     */
    public suspend fun getDomainIdentity(domain: String): GetDomainIdentityResult {
        val argument = GetDomainIdentityPlainArgs(
            domain = domain,
        )
        return getDomainIdentityResultToKotlin(getDomainIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ses&#46;kotlin&#46;inputs&#46;GetDomainIdentityPlainArgs].
     * @return A collection of values returned by getDomainIdentity.
     */
    public suspend fun getDomainIdentity(argument: suspend GetDomainIdentityPlainArgsBuilder.() -> Unit): GetDomainIdentityResult {
        val builder = GetDomainIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainIdentityResultToKotlin(getDomainIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the active SES email identity
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ses.getEmailIdentity({
     *     email: "awesome@example.com",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ses.get_email_identity(email="awesome@example.com")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ses.GetEmailIdentity.Invoke(new()
     *     {
     *         Email = "awesome@example.com",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ses.LookupEmailIdentity(ctx, &ses.LookupEmailIdentityArgs{
     * 			Email: "awesome@example.com",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ses.SesFunctions;
     * import com.pulumi.aws.ses.inputs.GetEmailIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SesFunctions.getEmailIdentity(GetEmailIdentityArgs.builder()
     *             .email("awesome@example.com")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ses:getEmailIdentity
     *       Arguments:
     *         email: awesome@example.com
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEmailIdentity.
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend fun getEmailIdentity(argument: GetEmailIdentityPlainArgs): GetEmailIdentityResult =
        getEmailIdentityResultToKotlin(getEmailIdentityPlain(argument.toJava()).await())

    /**
     * @see [getEmailIdentity].
     * @param email Email identity.
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend fun getEmailIdentity(email: String): GetEmailIdentityResult {
        val argument = GetEmailIdentityPlainArgs(
            email = email,
        )
        return getEmailIdentityResultToKotlin(getEmailIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getEmailIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ses&#46;kotlin&#46;inputs&#46;GetEmailIdentityPlainArgs].
     * @return A collection of values returned by getEmailIdentity.
     */
    public suspend fun getEmailIdentity(argument: suspend GetEmailIdentityPlainArgsBuilder.() -> Unit): GetEmailIdentityResult {
        val builder = GetEmailIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEmailIdentityResultToKotlin(getEmailIdentityPlain(builtArgument.toJava()).await())
    }
}
