@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Template].
 */
@PulumiTagMarker
public class TemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArgs = TemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArgsBuilder.() -> Unit) {
        val builder = TemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Template {
        val builtJavaResource = com.pulumi.aws.ses.Template(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Template(builtJavaResource)
    }
}

/**
 * Provides a resource to create a SES template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myTemplate = new aws.ses.Template("MyTemplate", {
 *     name: "MyTemplate",
 *     subject: "Greetings, {{name}}!",
 *     html: "<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *     text: `Hello {{name}},\x0d
 * Your favorite animal is {{favoriteanimal}}.`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_template = aws.ses.Template("MyTemplate",
 *     name="MyTemplate",
 *     subject="Greetings, {{name}}!",
 *     html="<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *     text="""Hello {{name}},\x0d
 * Your favorite animal is {{favoriteanimal}}.""")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myTemplate = new Aws.Ses.Template("MyTemplate", new()
 *     {
 *         Name = "MyTemplate",
 *         Subject = "Greetings, {{name}}!",
 *         Html = "<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *         Text = @"Hello {{name}},
 * Your favorite animal is {{favoriteanimal}}.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewTemplate(ctx, "MyTemplate", &ses.TemplateArgs{
 * 			Name:    pulumi.String("MyTemplate"),
 * 			Subject: pulumi.String("Greetings, {{name}}!"),
 * 			Html:    pulumi.String("<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>"),
 * 			Text:    pulumi.String("Hello {{name}},
\nYour favorite animal is {{favoriteanimal}}."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.Template;
 * import com.pulumi.aws.ses.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myTemplate = new Template("myTemplate", TemplateArgs.builder()
 *             .name("MyTemplate")
 *             .subject("Greetings, {{name}}!")
 *             .html("<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>")
 *             .text("""
 * Hello {{name}},
 * Your favorite animal is {{favoriteanimal}}.            """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myTemplate:
 *     type: aws:ses:Template
 *     name: MyTemplate
 *     properties:
 *       name: MyTemplate
 *       subject: Greetings, {{name}}!
 *       html: <h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>
 *       text: "Hello {{name}},\r\nYour favorite animal is {{favoriteanimal}}."
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES templates using the template name. For example:
 * ```sh
 * $ pulumi import aws:ses/template:Template MyTemplate MyTemplate
 * ```
 */
public class Template internal constructor(
    override val javaResource: com.pulumi.aws.ses.Template,
) : KotlinCustomResource(javaResource, TemplateMapper) {
    /**
     * The ARN of the SES template
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
     */
    public val html: Output<String>?
        get() = javaResource.html().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The subject line of the email.
     */
    public val subject: Output<String>?
        get() = javaResource.subject().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
     */
    public val text: Output<String>?
        get() = javaResource.text().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object TemplateMapper : ResourceMapper<Template> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.Template::class == javaResource::class

    override fun map(javaResource: Resource): Template = Template(
        javaResource as
            com.pulumi.aws.ses.Template,
    )
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Template].
 */
public suspend fun template(name: String, block: suspend TemplateResourceBuilder.() -> Unit): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 */
public fun template(name: String): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
