@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a SES template.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myTemplate = new aws.ses.Template("MyTemplate", {
 *     name: "MyTemplate",
 *     subject: "Greetings, {{name}}!",
 *     html: "<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *     text: `Hello {{name}},\x0d
 * Your favorite animal is {{favoriteanimal}}.`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_template = aws.ses.Template("MyTemplate",
 *     name="MyTemplate",
 *     subject="Greetings, {{name}}!",
 *     html="<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *     text="""Hello {{name}},\x0d
 * Your favorite animal is {{favoriteanimal}}.""")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myTemplate = new Aws.Ses.Template("MyTemplate", new()
 *     {
 *         Name = "MyTemplate",
 *         Subject = "Greetings, {{name}}!",
 *         Html = "<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>",
 *         Text = @"Hello {{name}},
 * Your favorite animal is {{favoriteanimal}}.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ses"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ses.NewTemplate(ctx, "MyTemplate", &ses.TemplateArgs{
 * 			Name:    pulumi.String("MyTemplate"),
 * 			Subject: pulumi.String("Greetings, {{name}}!"),
 * 			Html:    pulumi.String("<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>"),
 * 			Text:    pulumi.String("Hello {{name}},
\nYour favorite animal is {{favoriteanimal}}."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.Template;
 * import com.pulumi.aws.ses.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myTemplate = new Template("myTemplate", TemplateArgs.builder()
 *             .name("MyTemplate")
 *             .subject("Greetings, {{name}}!")
 *             .html("<h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>")
 *             .text("""
 * Hello {{name}},
 * Your favorite animal is {{favoriteanimal}}.            """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myTemplate:
 *     type: aws:ses:Template
 *     name: MyTemplate
 *     properties:
 *       name: MyTemplate
 *       subject: Greetings, {{name}}!
 *       html: <h1>Hello {{name}},</h1><p>Your favorite animal is {{favoriteanimal}}.</p>
 *       text: "Hello {{name}},\r\nYour favorite animal is {{favoriteanimal}}."
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SES templates using the template name. For example:
 * ```sh
 * $ pulumi import aws:ses/template:Template MyTemplate MyTemplate
 * ```
 * @property html The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
 * @property name The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
 * @property subject The subject line of the email.
 * @property text The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
 */
public data class TemplateArgs(
    public val html: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subject: Output<String>? = null,
    public val text: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.TemplateArgs> {
    override fun toJava(): com.pulumi.aws.ses.TemplateArgs = com.pulumi.aws.ses.TemplateArgs.builder()
        .html(html?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .subject(subject?.applyValue({ args0 -> args0 }))
        .text(text?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var html: Output<String>? = null

    private var name: Output<String>? = null

    private var subject: Output<String>? = null

    private var text: Output<String>? = null

    /**
     * @param value The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
     */
    @JvmName("yeblkyyfrpoqjhsr")
    public suspend fun html(`value`: Output<String>) {
        this.html = value
    }

    /**
     * @param value The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
     */
    @JvmName("njammdopowgdemyt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The subject line of the email.
     */
    @JvmName("gkpfikdxxaqdvwgh")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
     */
    @JvmName("lnkrhanuwwnovefj")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value The HTML body of the email. Must be less than 500KB in size, including both the text and HTML parts.
     */
    @JvmName("baictcrbxefebfgk")
    public suspend fun html(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.html = mapped
    }

    /**
     * @param value The name of the template. Cannot exceed 64 characters. You will refer to this name when you send email.
     */
    @JvmName("njlaerdlofspctgb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The subject line of the email.
     */
    @JvmName("vliqysipaxkmrtbw")
    public suspend fun subject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value The email body that will be visible to recipients whose email clients do not display HTML. Must be less than 500KB in size, including both the text and HTML parts.
     */
    @JvmName("hexhsdnnhofqyimd")
    public suspend fun text(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.text = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        html = html,
        name = name,
        subject = subject,
        text = text,
    )
}
